/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LdapServerProperties {
    private String primaryUrl;
    private String secondaryUrl;
    private boolean useSsl;
    private boolean anonymousBind;
    private String managerDn;
    private String managerPassword;
    private String baseDN;
    private String dnAttribute;
    private String referralMethod;
    private String groupBase;
    private String groupObjectClass;
    private String groupMembershipAttr;
    private String groupNamingAttr;
    private String adminGroupMappingRules;
    private boolean groupMappingEnabled;
    private String userBase;
    private String userObjectClass;
    private String usernameAttribute;
    private boolean forceUsernameToLowercase = false;
    private String userSearchBase = "";
    private String syncGroupMemberReplacePattern = "";
    private String syncUserMemberReplacePattern = "";
    private String groupSearchFilter;
    private String userSearchFilter;
    private boolean alternateUserSearchFilterEnabled;
    private String alternateUserSearchFilter;
    private String syncUserMemberFilter = "";
    private String syncGroupMemberFilter = "";
    private boolean disableEndpointIdentification = false;
    private boolean paginationEnabled = true;
    private String adminGroupMappingMemberAttr = "";

    public List<String> getLdapUrls() {
        String protocol;
        String string = protocol = this.useSsl ? "ldaps://" : "ldap://";
        if (StringUtils.isEmpty((String)this.primaryUrl)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(protocol + this.primaryUrl);
        if (!StringUtils.isEmpty((String)this.secondaryUrl)) {
            list.add(protocol + this.secondaryUrl);
        }
        return list;
    }

    public String getPrimaryUrl() {
        return this.primaryUrl;
    }

    public void setPrimaryUrl(String primaryUrl) {
        this.primaryUrl = primaryUrl;
    }

    public String getSecondaryUrl() {
        return this.secondaryUrl;
    }

    public void setSecondaryUrl(String secondaryUrl) {
        this.secondaryUrl = secondaryUrl;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isAnonymousBind() {
        return this.anonymousBind;
    }

    public void setAnonymousBind(boolean anonymousBind) {
        this.anonymousBind = anonymousBind;
    }

    public String getManagerDn() {
        return this.managerDn;
    }

    public void setManagerDn(String managerDn) {
        this.managerDn = managerDn;
    }

    public String getManagerPassword() {
        return this.managerPassword;
    }

    public void setManagerPassword(String managerPassword) {
        this.managerPassword = managerPassword;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        this.baseDN = baseDN;
    }

    public String getUserSearchBase() {
        return this.userSearchBase;
    }

    public void setUserSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
    }

    public String getUserSearchFilter(boolean useAlternateUserSearchFilter) {
        String filter = useAlternateUserSearchFilter ? this.alternateUserSearchFilter : this.userSearchFilter;
        return this.resolveUserSearchFilterPlaceHolders(filter);
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setForceUsernameToLowercase(boolean forceUsernameToLowercase) {
        this.forceUsernameToLowercase = forceUsernameToLowercase;
    }

    public boolean isForceUsernameToLowercase() {
        return this.forceUsernameToLowercase;
    }

    public String getGroupBase() {
        return this.groupBase;
    }

    public void setGroupBase(String groupBase) {
        this.groupBase = groupBase;
    }

    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    public String getGroupMembershipAttr() {
        return this.groupMembershipAttr;
    }

    public void setGroupMembershipAttr(String groupMembershipAttr) {
        this.groupMembershipAttr = groupMembershipAttr;
    }

    public String getGroupNamingAttr() {
        return this.groupNamingAttr;
    }

    public void setGroupNamingAttr(String groupNamingAttr) {
        this.groupNamingAttr = groupNamingAttr;
    }

    public String getAdminGroupMappingRules() {
        return this.adminGroupMappingRules;
    }

    public void setAdminGroupMappingRules(String adminGroupMappingRules) {
        this.adminGroupMappingRules = adminGroupMappingRules;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setUserSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
    }

    public void setAlternateUserSearchFilterEnabled(boolean alternateUserSearchFilterEnabled) {
        this.alternateUserSearchFilterEnabled = alternateUserSearchFilterEnabled;
    }

    public boolean isAlternateUserSearchFilterEnabled() {
        return this.alternateUserSearchFilterEnabled;
    }

    public void setAlternateUserSearchFilter(String alternateUserSearchFilter) {
        this.alternateUserSearchFilter = alternateUserSearchFilter;
    }

    public boolean isGroupMappingEnabled() {
        return this.groupMappingEnabled;
    }

    public void setGroupMappingEnabled(boolean groupMappingEnabled) {
        this.groupMappingEnabled = groupMappingEnabled;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public String getDnAttribute() {
        return this.dnAttribute;
    }

    public void setDnAttribute(String dnAttribute) {
        this.dnAttribute = dnAttribute;
    }

    public void setReferralMethod(String referralMethod) {
        this.referralMethod = referralMethod;
    }

    public String getReferralMethod() {
        return this.referralMethod;
    }

    public boolean isDisableEndpointIdentification() {
        return this.disableEndpointIdentification;
    }

    public void setDisableEndpointIdentification(boolean disableEndpointIdentification) {
        this.disableEndpointIdentification = disableEndpointIdentification;
    }

    public boolean isPaginationEnabled() {
        return this.paginationEnabled;
    }

    public void setPaginationEnabled(boolean paginationEnabled) {
        this.paginationEnabled = paginationEnabled;
    }

    public String getSyncGroupMemberReplacePattern() {
        return this.syncGroupMemberReplacePattern;
    }

    public void setSyncGroupMemberReplacePattern(String syncGroupMemberReplacePattern) {
        this.syncGroupMemberReplacePattern = syncGroupMemberReplacePattern;
    }

    public String getSyncUserMemberReplacePattern() {
        return this.syncUserMemberReplacePattern;
    }

    public void setSyncUserMemberReplacePattern(String syncUserMemberReplacePattern) {
        this.syncUserMemberReplacePattern = syncUserMemberReplacePattern;
    }

    public String getSyncUserMemberFilter() {
        return this.syncUserMemberFilter;
    }

    public void setSyncUserMemberFilter(String syncUserMemberFilter) {
        this.syncUserMemberFilter = syncUserMemberFilter;
    }

    public String getSyncGroupMemberFilter() {
        return this.syncGroupMemberFilter;
    }

    public void setSyncGroupMemberFilter(String syncGroupMemberFilter) {
        this.syncGroupMemberFilter = syncGroupMemberFilter;
    }

    public String getAdminGroupMappingMemberAttr() {
        return this.adminGroupMappingMemberAttr;
    }

    public void setAdminGroupMappingMemberAttr(String adminGroupMappingMemberAttr) {
        this.adminGroupMappingMemberAttr = adminGroupMappingMemberAttr;
    }

    public final boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)false);
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((int)1, (int)31, (Object)this);
    }

    protected String resolveUserSearchFilterPlaceHolders(String filter) {
        return filter.replace("{usernameAttribute}", this.usernameAttribute).replace("{userObjectClass}", this.userObjectClass);
    }
}

