/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.orm.dao.PrivilegeDAO;
import id.onyx.obdp.server.orm.dao.ViewInstanceDAO;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.RoleAuthorizationEntity;
import id.onyx.obdp.server.security.authentication.AmbariProxiedUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.OBDPUserDetails;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.OBDPGrantedAuthority;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Singleton
public class AuthorizationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationHelper.class);
    @Inject
    static Provider<PrivilegeDAO> privilegeDAOProvider;
    @Inject
    static Provider<ViewInstanceDAO> viewInstanceDAOProvider;

    public static String getProxyUserName(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        Object userDetails = authentication.getPrincipal();
        if (userDetails instanceof AmbariProxiedUserDetailsImpl) {
            AmbariProxiedUserDetailsImpl ambariProxiedUserDetails = (AmbariProxiedUserDetailsImpl)userDetails;
            return ambariProxiedUserDetails.getProxyUserDetails().getUsername();
        }
        return null;
    }

    public static String getProxyUserName() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication auth = securityContext.getAuthentication();
        return AuthorizationHelper.getProxyUserName(auth);
    }

    public Collection<GrantedAuthority> convertPrivilegesToAuthorities(Collection<PrivilegeEntity> privilegeEntities) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>(privilegeEntities.size());
        for (PrivilegeEntity privilegeEntity : privilegeEntities) {
            authorities.add(new OBDPGrantedAuthority(privilegeEntity));
        }
        return authorities;
    }

    public static String getAuthenticatedName() {
        return AuthorizationHelper.getAuthenticatedName(null);
    }

    public static String getAuthenticatedName(String defaultUsername) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication auth = securityContext.getAuthentication();
        return null == auth ? defaultUsername : auth.getName();
    }

    public static int getAuthenticatedId() {
        Object principal;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Object object = principal = authentication == null ? null : authentication.getPrincipal();
        if (principal instanceof OBDPUserDetails) {
            return ((OBDPUserDetails)principal).getUserId();
        }
        return -1;
    }

    public static boolean isAuthorized(ResourceType resourceType, Long resourceId, RoleAuthorization requiredAuthorization) {
        return AuthorizationHelper.isAuthorized(AuthorizationHelper.getAuthentication(), resourceType, resourceId, EnumSet.of(requiredAuthorization));
    }

    public static boolean isAuthorized(ResourceType resourceType, Long resourceId, Set<RoleAuthorization> requiredAuthorizations) {
        return AuthorizationHelper.isAuthorized(AuthorizationHelper.getAuthentication(), resourceType, resourceId, requiredAuthorizations);
    }

    public static boolean isAuthorized(Authentication authentication, ResourceType resourceType, Long resourceId, RoleAuthorization requiredAuthorization) {
        return AuthorizationHelper.isAuthorized(authentication, resourceType, resourceId, EnumSet.of(requiredAuthorization));
    }

    public static boolean isAuthorized(Authentication authentication, ResourceType resourceType, Long resourceId, Set<RoleAuthorization> requiredAuthorizations) {
        if (requiredAuthorizations == null || requiredAuthorizations.isEmpty()) {
            return true;
        }
        if (authentication == null) {
            return false;
        }
        for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
            if (grantedAuthority instanceof OBDPGrantedAuthority) {
                PermissionEntity permission;
                Collection<RoleAuthorizationEntity> userAuthorizations;
                OBDPGrantedAuthority ambariGrantedAuthority = (OBDPGrantedAuthority)grantedAuthority;
                PrivilegeEntity privilegeEntity = ambariGrantedAuthority.getPrivilegeEntity();
                ResourceEntity privilegeResource = privilegeEntity.getResource();
                ResourceType privilegeResourceType = ResourceType.translate(privilegeResource.getResourceType().getName());
                boolean resourceOK = ResourceType.OBDP == privilegeResourceType ? true : (resourceType == null || resourceType == privilegeResourceType ? resourceId == null || resourceId.equals(privilegeResource.getId()) : false);
                if (!resourceOK || (userAuthorizations = (permission = privilegeEntity.getPermission()) == null ? null : permission.getAuthorizations()) == null) continue;
                for (RoleAuthorizationEntity userAuthorization : userAuthorizations) {
                    try {
                        if (!requiredAuthorizations.contains((Object)RoleAuthorization.translate(userAuthorization.getAuthorizationId()))) continue;
                        return true;
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn("Invalid authorization name, '{}'... ignoring.", (Object)userAuthorization.getAuthorizationId());
                    }
                }
                continue;
            }
            LOG.warn("GrantedAuthority is not an instance of OBDPGrantedAuthority. Ignoring.");
        }
        return false;
    }

    public static void verifyAuthorization(ResourceType resourceType, Long resourceId, Set<RoleAuthorization> requiredAuthorizations) throws AuthorizationException {
        if (!AuthorizationHelper.isAuthorized(resourceType, resourceId, requiredAuthorizations)) {
            throw new AuthorizationException();
        }
    }

    public static void verifyAuthorization(Authentication authentication, ResourceType resourceType, Long resourceId, Set<RoleAuthorization> requiredAuthorizations) throws AuthorizationException {
        if (!AuthorizationHelper.isAuthorized(authentication, resourceType, resourceId, requiredAuthorizations)) {
            throw new AuthorizationException();
        }
    }

    public static Authentication getAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        return context == null ? null : context.getAuthentication();
    }

    public static void addLoginNameAlias(String ambariUserName, String loginAlias) {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attr != null) {
            LOG.info("Adding login alias '{}' for user name '{}'", (Object)loginAlias, (Object)ambariUserName);
            attr.setAttribute(loginAlias, (Object)ambariUserName, 1);
            attr.setAttribute(ambariUserName, (Object)loginAlias, 1);
        }
    }

    public static String resolveLoginAliasToUserName(String loginAlias) {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attr != null && attr.getAttribute(loginAlias, 1) != null) {
            return (String)attr.getAttribute(loginAlias, 1);
        }
        return loginAlias;
    }

    public static List<String> getAuthorizationNames(Authentication authentication) {
        ArrayList authorizationNames = Lists.newArrayList();
        if (authentication.getAuthorities() != null) {
            for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
                OBDPGrantedAuthority ambariGrantedAuthority = (OBDPGrantedAuthority)grantedAuthority;
                PrivilegeEntity privilegeEntity = ambariGrantedAuthority.getPrivilegeEntity();
                Collection<RoleAuthorizationEntity> roleAuthorizationEntities = privilegeEntity.getPermission().getAuthorizations();
                for (RoleAuthorizationEntity entity : roleAuthorizationEntities) {
                    authorizationNames.add(entity.getAuthorizationName());
                }
            }
        }
        return authorizationNames;
    }
}

