/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.LdapServerProperties;
import id.onyx.obdp.server.security.authorization.OBDPLdapUtils;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.AuthenticationException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.security.ldap.search.LdapUserSearch;

public class AmbariLdapBindAuthenticator
extends AbstractLdapAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariLdapBindAuthenticator.class);
    private static final String AMBARI_ADMIN_LDAP_ATTRIBUTE_KEY = "ambari_admin";
    private final OBDPLdapConfiguration ldapConfiguration;

    public AmbariLdapBindAuthenticator(BaseLdapPathContextSource contextSource, OBDPLdapConfiguration ldapConfiguration) {
        super((ContextSource)contextSource);
        this.ldapConfiguration = ldapConfiguration;
    }

    public DirContextOperations authenticate(Authentication authentication) {
        if (!(authentication instanceof UsernamePasswordAuthenticationToken)) {
            LOG.info("Unexpected authentication token type encountered ({}) - failing authentication.", (Object)authentication.getClass().getName());
            throw new BadCredentialsException("Unexpected authentication token type encountered.");
        }
        DirContextOperations user = this.authenticate((UsernamePasswordAuthenticationToken)authentication);
        LdapServerProperties ldapServerProperties = this.ldapConfiguration.getLdapServerProperties();
        if (StringUtils.isNotEmpty((String)ldapServerProperties.getAdminGroupMappingRules())) {
            this.setAmbariAdminAttr(user, ldapServerProperties);
        }
        String ldapUserName = user.getStringAttribute(ldapServerProperties.getUsernameAttribute());
        String loginName = authentication.getName();
        if (ldapUserName == null) {
            LOG.warn("The user data does not contain a value for {}.", (Object)ldapServerProperties.getUsernameAttribute());
        } else if (ldapUserName.isEmpty()) {
            LOG.warn("The user data contains an empty value for {}.", (Object)ldapServerProperties.getUsernameAttribute());
        } else {
            String processedLdapUserName;
            LOG.info("User with {}='{}' logged in with login alias '{}'", new Object[]{ldapServerProperties.getUsernameAttribute(), ldapUserName, loginName});
            if (ldapServerProperties.isForceUsernameToLowercase()) {
                processedLdapUserName = ldapUserName.toLowerCase();
                LOG.info("Forcing ldap username to be lowercase characters: {} ==> {}", (Object)ldapUserName, (Object)processedLdapUserName);
            } else {
                processedLdapUserName = ldapUserName;
            }
            if (!processedLdapUserName.equals(loginName.toLowerCase())) {
                AuthorizationHelper.addLoginNameAlias(processedLdapUserName, loginName.toLowerCase());
            }
        }
        return user;
    }

    private DirContextOperations authenticate(UsernamePasswordAuthenticationToken authentication) {
        DirContextOperations userFromSearch;
        String password;
        DirContextOperations user = null;
        String username = authentication.getName();
        Object credentials = authentication.getCredentials();
        String string = password = credentials instanceof String ? (String)credentials : null;
        if (StringUtils.isEmpty((String)username)) {
            LOG.debug("Empty username encountered - failing authentication.");
            throw new BadCredentialsException("Empty username encountered.");
        }
        LOG.debug("Authenticating {}", (Object)username);
        if (StringUtils.isEmpty((String)password)) {
            LOG.debug("Empty password encountered - failing authentication.");
            throw new BadCredentialsException("Empty password encountered.");
        }
        LdapUserSearch userSearch = this.getUserSearch();
        if (userSearch == null) {
            LOG.debug("The user search facility has not been set - failing authentication.");
            throw new BadCredentialsException("The user search facility has not been set.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Searching for user with username {}: {}", (Object)username, (Object)userSearch);
        }
        if ((userFromSearch = userSearch.searchForUser(username)) == null) {
            LOG.debug("LDAP user object not found for {}", (Object)username);
        } else {
            LOG.debug("Found LDAP user for {}: {}", (Object)username, (Object)userFromSearch.getDn());
            user = this.bind(userFromSearch, password);
            if (LOG.isTraceEnabled()) {
                Attributes attributes = user.getAttributes();
                if (attributes != null) {
                    StringBuilder builder = new StringBuilder();
                    NamingEnumeration<String> ids = attributes.getIDs();
                    try {
                        while (ids.hasMore()) {
                            String id = ids.next();
                            builder.append("\n\t");
                            builder.append(attributes.get(id));
                        }
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                    LOG.trace("User Attributes: {}", (Object)builder);
                } else {
                    LOG.trace("User Attributes: not available");
                }
            }
        }
        if (user == null) {
            LOG.debug("Invalid credentials for {} - failing authentication.", (Object)username);
            throw new BadCredentialsException("Invalid credentials.");
        }
        LOG.debug("Successfully authenticated {}", (Object)username);
        return user;
    }

    private DirContextOperations bind(DirContextOperations user, String password) {
        DirContextAdapter dirContextAdapter;
        ContextSource contextSource = this.getContextSource();
        if (contextSource == null) {
            String message = "Missing ContextSource - failing authentication.";
            LOG.debug(message);
            throw new InternalAuthenticationServiceException(message);
        }
        if (!(contextSource instanceof BaseLdapPathContextSource)) {
            String message = String.format("Unexpected ContextSource type (%s) - failing authentication.", contextSource.getClass().getName());
            LOG.debug(message);
            throw new InternalAuthenticationServiceException(message);
        }
        BaseLdapPathContextSource baseLdapPathContextSource = (BaseLdapPathContextSource)contextSource;
        Name userDistinguishedName = user.getDn();
        Name fullDn = OBDPLdapUtils.getFullDn(userDistinguishedName, baseLdapPathContextSource.getBaseLdapName());
        LOG.debug("Attempting to bind as {}", (Object)fullDn);
        DirContext dirContext = null;
        try {
            dirContext = baseLdapPathContextSource.getContext(fullDn.toString(), password);
            dirContextAdapter = new DirContextAdapter(user.getAttributes(), userDistinguishedName, (Name)baseLdapPathContextSource.getBaseLdapName());
        }
        catch (AuthenticationException e) {
            try {
                String message = String.format("Failed to bind as %s - %s", user.getDn().toString(), e.getMessage());
                if (LOG.isTraceEnabled()) {
                    LOG.trace(message, (Throwable)e);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug(message);
                }
                throw new BadCredentialsException("The username or password is incorrect.");
            }
            catch (Throwable throwable) {
                LdapUtils.closeContext(dirContext);
                throw throwable;
            }
        }
        LdapUtils.closeContext((DirContext)dirContext);
        return dirContextAdapter;
    }

    private DirContextOperations setAmbariAdminAttr(DirContextOperations user, LdapServerProperties ldapServerProperties) {
        String baseDn = ldapServerProperties.getBaseDN().toLowerCase();
        String groupBase = ldapServerProperties.getGroupBase().toLowerCase();
        String groupNamingAttribute = ldapServerProperties.getGroupNamingAttr();
        String adminGroupMappingMemberAttr = ldapServerProperties.getAdminGroupMappingMemberAttr();
        int indexOfBaseDn = groupBase.indexOf(baseDn);
        groupBase = indexOfBaseDn <= 0 ? "" : groupBase.substring(0, indexOfBaseDn - 1);
        String memberValue = StringUtils.isNotEmpty((String)adminGroupMappingMemberAttr) ? user.getStringAttribute(adminGroupMappingMemberAttr) : user.getNameInNamespace();
        LOG.debug("LDAP login - set '{}' as member attribute for adminGroupMappingRules", (Object)memberValue);
        String setAmbariAdminAttrFilter = this.resolveAmbariAdminAttrFilter(ldapServerProperties, memberValue);
        LOG.debug("LDAP login - set admin attr filter: {}", (Object)setAmbariAdminAttrFilter);
        AttributesMapper attributesMapper = attrs -> attrs.get(groupNamingAttribute).get();
        LdapTemplate ldapTemplate = new LdapTemplate(this.getContextSource());
        ldapTemplate.setIgnorePartialResultException(true);
        ldapTemplate.setIgnoreNameNotFoundException(true);
        List ambariAdminGroups = ldapTemplate.search(groupBase, setAmbariAdminAttrFilter, attributesMapper);
        if (ambariAdminGroups.size() > 0) {
            user.setAttributeValue(AMBARI_ADMIN_LDAP_ATTRIBUTE_KEY, (Object)true);
        }
        return user;
    }

    private String resolveAmbariAdminAttrFilter(LdapServerProperties ldapServerProperties, String memberValue) {
        String setAmbariAdminAttrFilter;
        String groupMembershipAttr = ldapServerProperties.getGroupMembershipAttr();
        String groupObjectClass = ldapServerProperties.getGroupObjectClass();
        String adminGroupMappingRules = ldapServerProperties.getAdminGroupMappingRules();
        String groupNamingAttribute = ldapServerProperties.getGroupNamingAttr();
        String groupSearchFilter = ldapServerProperties.getGroupSearchFilter();
        if (StringUtils.isEmpty((String)groupSearchFilter)) {
            String adminGroupMappingRegex = this.createAdminGroupMappingRegex(adminGroupMappingRules, groupNamingAttribute);
            setAmbariAdminAttrFilter = String.format("(&(%s=%s)(objectclass=%s)(|%s))", groupMembershipAttr, memberValue, groupObjectClass, adminGroupMappingRegex);
        } else {
            setAmbariAdminAttrFilter = String.format("(&(%s=%s)%s)", groupMembershipAttr, memberValue, groupSearchFilter);
        }
        return setAmbariAdminAttrFilter;
    }

    private String createAdminGroupMappingRegex(String adminGroupMappingRules, String groupNamingAttribute) {
        String[] adminGroupMappingRegexs = adminGroupMappingRules.split(",");
        StringBuilder builder = new StringBuilder("");
        for (String adminGroupMappingRegex : adminGroupMappingRegexs) {
            builder.append(String.format("(%s=%s)", groupNamingAttribute, adminGroupMappingRegex));
        }
        return builder.toString();
    }
}

