/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import com.google.inject.Inject;
import id.onyx.obdp.server.orm.dao.MemberDAO;
import id.onyx.obdp.server.orm.dao.PrivilegeDAO;
import id.onyx.obdp.server.orm.dao.UserDAO;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authentication.InvalidUsernamePasswordCombinationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.Users;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class AmbariLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Logger log = LoggerFactory.getLogger(AmbariLdapAuthoritiesPopulator.class);
    private AuthorizationHelper authorizationHelper;
    UserDAO userDAO;
    MemberDAO memberDAO;
    PrivilegeDAO privilegeDAO;
    Users users;

    @Inject
    public AmbariLdapAuthoritiesPopulator(AuthorizationHelper authorizationHelper, UserDAO userDAO, MemberDAO memberDAO, PrivilegeDAO privilegeDAO, Users users) {
        this.authorizationHelper = authorizationHelper;
        this.userDAO = userDAO;
        this.memberDAO = memberDAO;
        this.privilegeDAO = privilegeDAO;
        this.users = users;
    }

    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        username = AuthorizationHelper.resolveLoginAliasToUserName(username);
        log.info("Get authorities for user " + username + " from local DB");
        UserEntity user = this.userDAO.findUserByName(username);
        if (user == null) {
            log.error("Can't get authorities for user " + username + ", he is not present in local DB");
            return Collections.emptyList();
        }
        if (!user.getActive().booleanValue()) {
            throw new InvalidUsernamePasswordCombinationException(username);
        }
        Collection<PrivilegeEntity> privilegeEntities = this.users.getUserPrivileges(user);
        return this.authorizationHelper.convertPrivilegesToAuthorities(privilegeEntities);
    }
}

