/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.OBDPLdapConfigurationProvider;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.ClientSecurityType;
import id.onyx.obdp.server.security.authentication.AccountDisabledException;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationProvider;
import id.onyx.obdp.server.security.authentication.InvalidUsernamePasswordCombinationException;
import id.onyx.obdp.server.security.authentication.OBDPUserAuthentication;
import id.onyx.obdp.server.security.authentication.OBDPUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.TooManyLoginFailuresException;
import id.onyx.obdp.server.security.authorization.AmbariLdapAuthoritiesPopulator;
import id.onyx.obdp.server.security.authorization.AmbariLdapBindAuthenticator;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.DuplicateLdapUserFoundAuthenticationException;
import id.onyx.obdp.server.security.authorization.LdapServerProperties;
import id.onyx.obdp.server.security.authorization.OBDPLdapUtils;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.CommunicationException;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public class AmbariLdapAuthenticationProvider
extends AmbariAuthenticationProvider {
    private static final String SYSTEM_PROPERTY_DISABLE_ENDPOINT_IDENTIFICATION = "com.sun.jndi.ldap.object.disableEndpointIdentification";
    private static Logger LOG = LoggerFactory.getLogger(AmbariLdapAuthenticationProvider.class);
    final OBDPLdapConfigurationProvider ldapConfigurationProvider;
    private AmbariLdapAuthoritiesPopulator authoritiesPopulator;
    private ThreadLocal<LdapServerProperties> ldapServerProperties = new ThreadLocal();
    private ThreadLocal<LdapAuthenticationProvider> providerThreadLocal = new ThreadLocal();
    private ThreadLocal<String> ldapUserSearchFilterThreadLocal = new ThreadLocal();

    @Inject
    public AmbariLdapAuthenticationProvider(Users users, Configuration configuration, OBDPLdapConfigurationProvider ldapConfigurationProvider, AmbariLdapAuthoritiesPopulator authoritiesPopulator) {
        super(users, configuration);
        this.ldapConfigurationProvider = ldapConfigurationProvider;
        this.authoritiesPopulator = authoritiesPopulator;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (this.isLdapEnabled()) {
            if (authentication.getName() == null) {
                LOG.info("Authentication failed: no username provided");
                throw new InvalidUsernamePasswordCombinationException("");
            }
            String username = authentication.getName().trim();
            if (authentication.getCredentials() == null) {
                LOG.info("Authentication failed: no credentials provided: {}", (Object)username);
                throw new InvalidUsernamePasswordCombinationException(username);
            }
            try {
                Authentication auth = this.loadLdapAuthenticationProvider(username).authenticate(authentication);
                UserEntity userEntity = this.getUserEntity(auth);
                if (userEntity == null) {
                    LOG.debug("user not found ('{}')", (Object)username);
                    throw new InvalidUsernamePasswordCombinationException(username);
                }
                Users users = this.getUsers();
                try {
                    users.validateLogin(userEntity, username);
                }
                catch (AccountDisabledException | TooManyLoginFailuresException e) {
                    if (this.getConfiguration().showLockedOutUserMessage()) {
                        throw e;
                    }
                    throw new InvalidUsernamePasswordCombinationException(username, false, (Throwable)((Object)e));
                }
                OBDPUserDetailsImpl userDetails = new OBDPUserDetailsImpl(users.getUser(userEntity), null, users.getUserAuthorities(userEntity));
                return new OBDPUserAuthentication(null, userDetails, true);
            }
            catch (AuthenticationException e) {
                LOG.debug("Got exception during LDAP authentication attempt", (Throwable)e);
                Throwable cause = e.getCause();
                if (cause != null && cause != e) {
                    if (cause instanceof CommunicationException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Failed to communicate with the LDAP server: " + cause.getMessage(), (Throwable)e);
                        } else {
                            LOG.warn("Failed to communicate with the LDAP server: " + cause.getMessage());
                        }
                    } else if (cause instanceof org.springframework.ldap.AuthenticationException) {
                        LOG.warn("Looks like LDAP manager credentials (that are used for connecting to LDAP server) are invalid.", (Throwable)e);
                    }
                }
                throw new InvalidUsernamePasswordCombinationException(username, e);
            }
            catch (IncorrectResultSizeDataAccessException multipleUsersFound) {
                String message = ((OBDPLdapConfiguration)this.ldapConfigurationProvider.get()).isLdapAlternateUserSearchEnabled() ? String.format("Login Failed: Please append your domain to your username and try again.  Example: %s@domain", username) : "Login Failed: More than one user with that username found, please work with your Ambari Administrator to adjust your LDAP configuration";
                throw new DuplicateLdapUserFoundAuthenticationException(message);
            }
        }
        return null;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    LdapAuthenticationProvider loadLdapAuthenticationProvider(String userName) {
        boolean ldapConfigPropertiesChanged = this.reloadLdapServerProperties();
        String ldapUserSearchFilter = this.getLdapUserSearchFilter(userName);
        if (ldapConfigPropertiesChanged || !ldapUserSearchFilter.equals(this.ldapUserSearchFilterThreadLocal.get())) {
            LOG.info("Either LDAP Properties or user search filter changed - rebuilding Context");
            LdapContextSource springSecurityContextSource = new LdapContextSource();
            List<String> ldapUrls = this.ldapServerProperties.get().getLdapUrls();
            springSecurityContextSource.setUrls(ldapUrls.toArray(new String[ldapUrls.size()]));
            springSecurityContextSource.setBase(this.ldapServerProperties.get().getBaseDN());
            if (!this.ldapServerProperties.get().isAnonymousBind()) {
                springSecurityContextSource.setUserDn(this.ldapServerProperties.get().getManagerDn());
                springSecurityContextSource.setPassword(this.ldapServerProperties.get().getManagerPassword());
            }
            if (this.ldapServerProperties.get().isUseSsl() && this.ldapServerProperties.get().isDisableEndpointIdentification()) {
                System.setProperty(SYSTEM_PROPERTY_DISABLE_ENDPOINT_IDENTIFICATION, "true");
                LOG.info("Disabled endpoint identification");
            } else {
                System.clearProperty(SYSTEM_PROPERTY_DISABLE_ENDPOINT_IDENTIFICATION);
                LOG.info("Removed endpoint identification disabling");
            }
            try {
                springSecurityContextSource.afterPropertiesSet();
            }
            catch (Exception e) {
                LOG.error("LDAP Context Source not loaded ", (Throwable)e);
                throw new UsernameNotFoundException("LDAP Context Source not loaded", (Throwable)e);
            }
            String userSearchBase = this.ldapServerProperties.get().getUserSearchBase();
            FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(userSearchBase, ldapUserSearchFilter, (BaseLdapPathContextSource)springSecurityContextSource);
            AmbariLdapBindAuthenticator bindAuthenticator = new AmbariLdapBindAuthenticator((BaseLdapPathContextSource)springSecurityContextSource, (OBDPLdapConfiguration)this.ldapConfigurationProvider.get());
            bindAuthenticator.setUserSearch((LdapUserSearch)userSearch);
            LdapAuthenticationProvider authenticationProvider = new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator, (LdapAuthoritiesPopulator)this.authoritiesPopulator);
            this.providerThreadLocal.set(authenticationProvider);
        }
        this.ldapUserSearchFilterThreadLocal.set(ldapUserSearchFilter);
        return this.providerThreadLocal.get();
    }

    boolean isLdapEnabled() {
        return this.getConfiguration().getClientSecurityType() == ClientSecurityType.LDAP;
    }

    private boolean reloadLdapServerProperties() {
        LdapServerProperties properties = ((OBDPLdapConfiguration)this.ldapConfigurationProvider.get()).getLdapServerProperties();
        if (!properties.equals(this.ldapServerProperties.get())) {
            LOG.info("Reloading properties");
            this.ldapServerProperties.set(properties);
            return true;
        }
        return false;
    }

    private String getLdapUserSearchFilter(String userName) {
        return this.ldapServerProperties.get().getUserSearchFilter(((OBDPLdapConfiguration)this.ldapConfigurationProvider.get()).isLdapAlternateUserSearchEnabled() && OBDPLdapUtils.isUserPrincipalNameFormat(userName));
    }

    private UserEntity getUserEntity(Authentication authentication) {
        UserEntity userEntity = null;
        String dn = this.getUserDN(authentication);
        if (!StringUtils.isEmpty((String)dn)) {
            userEntity = this.getUserEntityForDN(dn);
        }
        if (userEntity == null) {
            String userName = AuthorizationHelper.resolveLoginAliasToUserName(authentication.getName());
            userEntity = this.getUsers().getUserEntity(userName);
            if (userEntity != null) {
                Collection<UserAuthenticationEntity> authenticationEntities = this.getAuthenticationEntities(userEntity, UserAuthenticationType.LDAP);
                UserEntity _userEntity = userEntity;
                userEntity = null;
                if (!CollectionUtils.isEmpty(authenticationEntities)) {
                    for (UserAuthenticationEntity entity : authenticationEntities) {
                        if (!StringUtils.isEmpty((String)entity.getAuthenticationKey())) continue;
                        userEntity = _userEntity;
                        break;
                    }
                }
            }
        }
        return userEntity;
    }

    private UserEntity getUserEntityForDN(String dn) {
        Collection<UserAuthenticationEntity> authenticationEntities = this.getAuthenticationEntities(UserAuthenticationType.LDAP, StringUtils.lowerCase((String)dn));
        return authenticationEntities == null || authenticationEntities.size() != 1 ? null : authenticationEntities.iterator().next().getUser();
    }

    private String getUserDN(Authentication authentication) {
        Object objectPrincipal;
        Object object = objectPrincipal = authentication == null ? null : authentication.getPrincipal();
        if (objectPrincipal instanceof LdapUserDetails) {
            return ((LdapUserDetails)objectPrincipal).getDn();
        }
        return null;
    }
}

