/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.tproxy;

import id.onyx.obdp.server.utils.RequestUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class TrustedProxyAuthenticationDetails
extends WebAuthenticationDetails {
    private final String doAs;
    private final String xForwardedContext;
    private final String xForwardedProto;
    private final String xForwardedHost;
    private final String xForwardedFor;
    private final String xForwardedPort;
    private final String xForwardedServer;

    TrustedProxyAuthenticationDetails(HttpServletRequest context) {
        super(context);
        this.doAs = RequestUtils.getQueryStringParameterValue(context, "doAs");
        this.xForwardedContext = context.getHeader("X-Forwarded-Context");
        this.xForwardedProto = context.getHeader("X-Forwarded-Proto");
        this.xForwardedHost = context.getHeader("X-Forwarded-Host");
        this.xForwardedFor = context.getHeader("X-Forwarded-For");
        this.xForwardedPort = context.getHeader("X-Forwarded-Port");
        this.xForwardedServer = context.getHeader("X-Forwarded-Server");
    }

    public String getDoAs() {
        return this.doAs;
    }

    public String getXForwardedContext() {
        return this.xForwardedContext;
    }

    public String getXForwardedProto() {
        return this.xForwardedProto;
    }

    public String getXForwardedHost() {
        return this.xForwardedHost;
    }

    public String getXForwardedFor() {
        return this.xForwardedFor;
    }

    public String getXForwardedPort() {
        return this.xForwardedPort;
    }

    public String getXForwardedServer() {
        return this.xForwardedServer;
    }
}

