/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.tproxy;

import id.onyx.obdp.server.configuration.OBDPServerConfiguration;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AmbariTProxyConfiguration
extends OBDPServerConfiguration {
    private static final String TEMPLATE_PROXY_USER_ALLOWED_HOSTS = "ambari.tproxy.proxyuser.%s.hosts";
    private static final String TEMPLATE_PROXY_USER_ALLOWED_USERS = "ambari.tproxy.proxyuser.%s.users";
    private static final String TEMPLATE_PROXY_USER_ALLOWED_GROUPS = "ambari.tproxy.proxyuser.%s.groups";

    AmbariTProxyConfiguration(Map<String, String> configurationMap) {
        super(configurationMap);
    }

    @Override
    protected OBDPServerConfigurationCategory getCategory() {
        return OBDPServerConfigurationCategory.TPROXY_CONFIGURATION;
    }

    public boolean isEnabled() {
        return Boolean.valueOf(this.getValue(OBDPServerConfigurationKey.TPROXY_AUTHENTICATION_ENABLED, this.configurationMap));
    }

    public String getAllowedHosts(String proxyUser) {
        return this.getValue(String.format(TEMPLATE_PROXY_USER_ALLOWED_HOSTS, proxyUser), this.configurationMap, OBDPServerConfigurationKey.TPROXY_ALLOWED_HOSTS.getDefaultValue());
    }

    public String getAllowedUsers(String proxyUser) {
        return this.getValue(String.format(TEMPLATE_PROXY_USER_ALLOWED_USERS, proxyUser), this.configurationMap, OBDPServerConfigurationKey.TPROXY_ALLOWED_USERS.getDefaultValue());
    }

    public String getAllowedGroups(String proxyUser) {
        return this.getValue(String.format(TEMPLATE_PROXY_USER_ALLOWED_GROUPS, proxyUser), this.configurationMap, OBDPServerConfigurationKey.TPROXY_ALLOWED_GROUPS.getDefaultValue());
    }

    public boolean equals(Object o) {
        return new EqualsBuilder().append((Object)this.configurationMap, (Object)((AmbariTProxyConfiguration)o).configurationMap).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.configurationMap).toHashCode();
    }
}

