/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.pam;

import id.onyx.obdp.server.configuration.Configuration;
import jakarta.inject.Singleton;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;

@Singleton
public class PamAuthenticationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PamAuthenticationFactory.class);

    public PAM createInstance(Configuration configuration) {
        String pamConfig = configuration == null ? null : configuration.getPamConfigurationFile();
        return this.createInstance(pamConfig);
    }

    public PAM createInstance(String pamConfig) {
        try {
            return new PAM(pamConfig);
        }
        catch (PAMException e) {
            String message = String.format("Unable to Initialize PAM: %s", e.getMessage());
            LOG.error(message, (Throwable)e);
            throw new AuthenticationServiceException(message, (Throwable)e);
        }
    }
}

