/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.pam;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.ClientSecurityType;
import id.onyx.obdp.server.security.authentication.AccountDisabledException;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationException;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationProvider;
import id.onyx.obdp.server.security.authentication.InvalidUsernamePasswordCombinationException;
import id.onyx.obdp.server.security.authentication.OBDPUserAuthentication;
import id.onyx.obdp.server.security.authentication.OBDPUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.TooManyLoginFailuresException;
import id.onyx.obdp.server.security.authentication.pam.PamAuthenticationFactory;
import id.onyx.obdp.server.security.authorization.GroupType;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class AmbariPamAuthenticationProvider
extends AmbariAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariPamAuthenticationProvider.class);
    private final PamAuthenticationFactory pamAuthenticationFactory;

    @Inject
    public AmbariPamAuthenticationProvider(Users users, PamAuthenticationFactory pamAuthenticationFactory, Configuration configuration) {
        super(users, configuration);
        this.pamAuthenticationFactory = pamAuthenticationFactory;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (this.isPamEnabled()) {
            String localUsername;
            String ambariUsername;
            if (authentication.getName() == null) {
                LOG.info("Authentication failed: no username provided");
                throw new InvalidUsernamePasswordCombinationException("");
            }
            String userName = authentication.getName().trim();
            if (authentication.getCredentials() == null) {
                LOG.info("Authentication failed: no credentials provided: {}", (Object)userName);
                throw new InvalidUsernamePasswordCombinationException(userName);
            }
            Users users = this.getUsers();
            UserEntity userEntity = users.getUserEntity(userName);
            String password = String.valueOf(authentication.getCredentials());
            if (userEntity == null) {
                ambariUsername = userName;
                localUsername = userName;
            } else {
                UserAuthenticationEntity authenticationEntity = this.getAuthenticationEntity(userEntity, UserAuthenticationType.PAM);
                ambariUsername = userEntity.getUserName();
                if (authenticationEntity == null) {
                    localUsername = userEntity.getLocalUsername();
                } else {
                    localUsername = authenticationEntity.getAuthenticationKey();
                    if (StringUtils.isEmpty((String)localUsername)) {
                        localUsername = userEntity.getLocalUsername();
                    }
                }
                if (StringUtils.isEmpty((String)localUsername)) {
                    localUsername = ambariUsername;
                }
            }
            UnixUser unixUser = this.performPAMAuthentication(ambariUsername, localUsername, password);
            if (unixUser != null) {
                if (userEntity == null) {
                    try {
                        userEntity = users.createUser(ambariUsername, unixUser.getUserName(), ambariUsername, true);
                    }
                    catch (OBDPException e) {
                        LOG.error(String.format("Failed to add the user, %s: %s", ambariUsername, e.getLocalizedMessage()), (Throwable)e);
                        throw new AmbariAuthenticationException(ambariUsername, "Unexpected error has occurred", false, e);
                    }
                }
                try {
                    users.validateLogin(userEntity, ambariUsername);
                }
                catch (AccountDisabledException | TooManyLoginFailuresException e) {
                    if (this.getConfiguration().showLockedOutUserMessage()) {
                        throw e;
                    }
                    throw new InvalidUsernamePasswordCombinationException(userName, false, (Throwable)((Object)e));
                }
                UserAuthenticationEntity authenticationEntity = this.getAuthenticationEntity(userEntity, UserAuthenticationType.PAM);
                if (authenticationEntity == null) {
                    try {
                        users.addPamAuthentication(userEntity, unixUser.getUserName());
                    }
                    catch (OBDPException e) {
                        LOG.error(String.format("Failed to add the PAM authentication method for %s: %s", ambariUsername, e.getLocalizedMessage()), (Throwable)e);
                        throw new AmbariAuthenticationException(ambariUsername, "Unexpected error has occurred", false, e);
                    }
                }
                if (this.isAutoGroupCreationAllowed()) {
                    this.synchronizeGroups(unixUser, userEntity);
                }
                OBDPUserDetailsImpl userDetails = new OBDPUserDetailsImpl(users.getUser(userEntity), null, users.getUserAuthorities(userEntity));
                return new OBDPUserAuthentication(password, userDetails, true);
            }
            LOG.debug(String.format("Authentication failed: password does not match stored value: %s", localUsername));
            throw new InvalidUsernamePasswordCombinationException(ambariUsername);
        }
        return null;
    }

    private UnixUser performPAMAuthentication(String ambariUsername, String localUsername, String password) {
        PAM pam = this.pamAuthenticationFactory.createInstance(this.getConfiguration());
        if (pam == null) {
            String message = "Failed to authenticate the user using the PAM authentication method: unexpected error";
            LOG.error(message);
            throw new AmbariAuthenticationException(ambariUsername, message, false);
        }
        if (LOG.isDebugEnabled() && !ambariUsername.equals(localUsername)) {
            LOG.debug("Authenticating Ambari user {} using the local username {}", (Object)ambariUsername, (Object)localUsername);
        }
        try {
            UnixUser message = pam.authenticate(localUsername, password);
            return message;
        }
        catch (PAMException e) {
            LOG.debug(String.format("Authentication failed: password does not match stored value: %s", localUsername), (Throwable)e);
            throw new InvalidUsernamePasswordCombinationException(ambariUsername, true, e);
        }
        finally {
            pam.dispose();
        }
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private boolean isPamEnabled() {
        return this.getConfiguration().getClientSecurityType() == ClientSecurityType.PAM;
    }

    private boolean isAutoGroupCreationAllowed() {
        return this.getConfiguration().getAutoGroupCreation().equals("true");
    }

    private void synchronizeGroups(UnixUser unixUser, UserEntity userEntity) {
        LOG.debug("Synchronizing groups for PAM user: {}", (Object)unixUser.getUserName());
        Users users = this.getUsers();
        try {
            Set<String> unixUserGroups = this.convertToLowercase(unixUser.getGroups());
            for (String group : unixUserGroups) {
                GroupEntity groupEntity = users.getGroupEntity(group, GroupType.PAM);
                if (groupEntity == null) {
                    LOG.info("Synchronizing groups for {}, adding new PAM group: {}", (Object)userEntity.getUserName(), (Object)group);
                    groupEntity = users.createGroup(group, GroupType.PAM);
                }
                if (users.isUserInGroup(userEntity, groupEntity)) continue;
                LOG.info("Synchronizing groups for {}, adding user to PAM group: {}", (Object)userEntity.getUserName(), (Object)group);
                users.addMemberToGroup(groupEntity, userEntity);
            }
            Set<MemberEntity> memberEntities = userEntity.getMemberEntities();
            if (memberEntities != null) {
                ArrayList<GroupEntity> groupsToRemove = new ArrayList<GroupEntity>();
                for (MemberEntity memberEntity : memberEntities) {
                    GroupEntity groupEntity = memberEntity.getGroup();
                    if (groupEntity.getGroupType() != GroupType.PAM || unixUserGroups.contains(groupEntity.getGroupName())) continue;
                    groupsToRemove.add(groupEntity);
                }
                for (GroupEntity groupEntity : groupsToRemove) {
                    LOG.info("Synchronizing groups for {}, removing user from PAM group: {}", (Object)userEntity.getUserName(), (Object)groupEntity.getGroupName());
                    users.removeMemberFromGroup(groupEntity, userEntity);
                }
            }
        }
        catch (OBDPException e) {
            e.printStackTrace();
        }
    }

    private Set<String> convertToLowercase(Set<String> groups) {
        HashSet<String> lowercaseGroups = new HashSet<String>();
        if (groups != null) {
            for (String group : groups) {
                lowercaseGroups.add(group.toLowerCase());
            }
        }
        return lowercaseGroups;
    }
}

