/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.kerberos;

import com.google.inject.Provider;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authentication.AccountDisabledException;
import id.onyx.obdp.server.security.authentication.InvalidUsernamePasswordCombinationException;
import id.onyx.obdp.server.security.authentication.OBDPUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.TooManyLoginFailuresException;
import id.onyx.obdp.server.security.authentication.tproxy.AmbariTProxyConfiguration;
import id.onyx.obdp.server.security.authentication.tproxy.TrustedProxyAuthenticationDetails;
import id.onyx.obdp.server.security.authentication.tproxy.TrustedProxyAuthenticationNotAllowedException;
import id.onyx.obdp.server.security.authorization.User;
import id.onyx.obdp.server.security.authorization.Users;
import jakarta.inject.Inject;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class OBDPProxiedUserDetailsService
implements UserDetailsService {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPProxiedUserDetailsService.class);
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(?:\\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}$");
    private static final Pattern IP_ADDRESS_RANGE_PATTERN = Pattern.compile("^((?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(?:\\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3})/(\\d{1,2})$");
    @Inject
    private Provider<AmbariTProxyConfiguration> obdpTProxyConfigurationProvider;
    private final Configuration configuration;
    private final Users users;

    OBDPProxiedUserDetailsService(Configuration configuration, Users users) {
        this.configuration = configuration;
        this.users = users;
    }

    public UserDetails loadUserByUsername(String proxiedUserName) throws UsernameNotFoundException {
        return this.loadProxiedUser(proxiedUserName, null, null);
    }

    public UserDetails loadProxiedUser(String proxiedUserName, String proxyUserName, TrustedProxyAuthenticationDetails trustedProxyAuthenticationDetails) throws AuthenticationException {
        LOG.info("Proxy user {} specified {} as proxied user.", (Object)proxyUserName, (Object)proxiedUserName);
        if (StringUtils.isEmpty((String)proxiedUserName)) {
            String message = "No proxied username was specified.";
            LOG.warn(message);
            throw new UsernameNotFoundException(message);
        }
        if (trustedProxyAuthenticationDetails == null) {
            String message = "Trusted proxy details have not been provided.";
            LOG.warn(message);
            throw new TrustedProxyAuthenticationNotAllowedException(message);
        }
        AmbariTProxyConfiguration tProxyConfiguration = (AmbariTProxyConfiguration)this.obdpTProxyConfigurationProvider.get();
        if (!tProxyConfiguration.isEnabled()) {
            String message = "Trusted proxy support is not enabled.";
            LOG.warn(message);
            throw new TrustedProxyAuthenticationNotAllowedException(message);
        }
        if (!this.validateHost(tProxyConfiguration, proxyUserName, trustedProxyAuthenticationDetails.getRemoteAddress())) {
            String message = String.format("Trusted proxy is not allowed for %s -> %s: host match not found.", proxyUserName, proxiedUserName);
            LOG.warn(message);
            throw new TrustedProxyAuthenticationNotAllowedException(message);
        }
        if (!this.validateUser(tProxyConfiguration, proxyUserName, proxiedUserName)) {
            String message = String.format("Trusted proxy is not allowed for %s -> %s: user match not found.", proxyUserName, proxiedUserName);
            LOG.warn(message);
            throw new TrustedProxyAuthenticationNotAllowedException(message);
        }
        UserEntity userEntity = this.users.getUserEntity(proxiedUserName);
        if (userEntity == null) {
            String message = String.format("Failed to find an account for the proxied user, %s.", proxiedUserName);
            LOG.warn(message);
            throw new UsernameNotFoundException(message);
        }
        if (!this.validateGroup(tProxyConfiguration, proxyUserName, userEntity)) {
            String message = String.format("Trusted proxy is not allowed for %s -> %s: group match not found.", proxyUserName, proxiedUserName);
            LOG.warn(message);
            throw new TrustedProxyAuthenticationNotAllowedException(message);
        }
        return this.createUserDetails(userEntity);
    }

    boolean validateGroup(AmbariTProxyConfiguration tProxyConfiguration, String proxyUserName, UserEntity userEntity) {
        String allowedGroups = tProxyConfiguration.getAllowedGroups(proxyUserName);
        if (StringUtils.isNotEmpty((String)allowedGroups)) {
            Set groupSpecs = Arrays.stream(allowedGroups.split("\\s*,\\s*")).map(s -> s.trim().toLowerCase()).collect(Collectors.toSet());
            if (groupSpecs.contains("*")) {
                return true;
            }
            Set<MemberEntity> memberEntities = userEntity.getMemberEntities();
            if (memberEntities != null) {
                for (MemberEntity memberEntity : memberEntities) {
                    String groupName;
                    GroupEntity group = memberEntity.getGroup();
                    if (group == null || !StringUtils.isNotEmpty((String)(groupName = group.getGroupName())) || !groupSpecs.contains(groupName.toLowerCase())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean validateUser(AmbariTProxyConfiguration tProxyConfiguration, String proxyUserName, String proxiedUserName) {
        String allowedUsers = tProxyConfiguration.getAllowedUsers(proxyUserName);
        if (StringUtils.isNotEmpty((String)allowedUsers)) {
            String[] userSpecs;
            for (String userSpec : userSpecs = allowedUsers.split("\\s*,\\s*")) {
                if (!"*".equals(userSpec) && !userSpec.equalsIgnoreCase(proxiedUserName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean validateHost(AmbariTProxyConfiguration tProxyConfiguration, String proxyUserName, String remoteAddress) {
        String allowedHosts = tProxyConfiguration.getAllowedHosts(proxyUserName);
        if (StringUtils.isNotEmpty((String)allowedHosts)) {
            Set hostSpecs = Arrays.stream(allowedHosts.split("\\s*,\\s*")).map(s -> s.trim().toLowerCase()).collect(Collectors.toSet());
            if (hostSpecs.contains("*")) {
                return true;
            }
            for (String hostSpec : hostSpecs) {
                if (!(this.isIPAddress(hostSpec) ? hostSpec.equals(remoteAddress) : (this.isIPAddressRange(hostSpec) ? this.isInIpAddressRange(hostSpec, remoteAddress) : this.matchesHostname(hostSpec, remoteAddress)))) continue;
                return true;
            }
        }
        return false;
    }

    boolean matchesHostname(String hostSpec, String remoteAddress) {
        try {
            String ipAddress = this.getIpAddress(hostSpec);
            if (StringUtils.isNotEmpty((String)ipAddress) && ipAddress.equals(remoteAddress)) {
                return true;
            }
        }
        catch (Throwable t) {
            LOG.warn("Invalid hostname in host specification, skipping: " + hostSpec, t);
        }
        return false;
    }

    String getIpAddress(String hostname) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(hostname);
        return inetAddress == null ? null : inetAddress.getHostAddress();
    }

    boolean isInIpAddressRange(String cidr, String ipAddress) {
        Matcher matcher = IP_ADDRESS_RANGE_PATTERN.matcher(cidr);
        if (matcher.matches() && matcher.groupCount() == 2) {
            try {
                String hostSpecIPAddress = matcher.group(1);
                String hostSpecBits = matcher.group(2);
                int hostSpecIPAddressInt = this.ipAddressToInt(hostSpecIPAddress);
                int remoteAddressInt = this.ipAddressToInt(ipAddress);
                int mask = -1 << 32 - Integer.valueOf(hostSpecBits);
                return (hostSpecIPAddressInt & mask) == (remoteAddressInt & mask);
            }
            catch (Throwable t) {
                LOG.warn("Invalid CIDR in host specification, skipping: " + cidr, t);
            }
        }
        return false;
    }

    private int ipAddressToInt(String s) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(s);
        byte[] b = inetAddress.getAddress();
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | (b[3] & 0xFF) << 0;
    }

    private boolean isIPAddressRange(String hostSpec) {
        return IP_ADDRESS_RANGE_PATTERN.matcher(hostSpec).matches();
    }

    private boolean isIPAddress(String hostSpec) {
        return IP_ADDRESS_PATTERN.matcher(hostSpec).matches();
    }

    private UserDetails createUserDetails(UserEntity userEntity) {
        String username = userEntity.getUserName();
        try {
            this.users.validateLogin(userEntity, username);
        }
        catch (AccountDisabledException | TooManyLoginFailuresException e) {
            if (this.configuration.showLockedOutUserMessage()) {
                throw e;
            }
            throw new InvalidUsernamePasswordCombinationException(username, false, (Throwable)((Object)e));
        }
        return new OBDPUserDetailsImpl(new User(userEntity), null, this.users.getUserAuthorities(userEntity));
    }
}

