/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.kerberos;

import id.onyx.obdp.server.security.authentication.AmbariProxiedUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariAuthToLocalUserDetailsService;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariProxyUserKerberosDetailsImpl;
import id.onyx.obdp.server.security.authentication.kerberos.OBDPProxiedUserDetailsService;
import id.onyx.obdp.server.security.authentication.tproxy.TrustedProxyAuthenticationDetails;
import jakarta.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;

public class OBDPKerberosAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPKerberosAuthenticationProvider.class);
    private AmbariAuthToLocalUserDetailsService authToLocalUserDetailsService;
    private OBDPProxiedUserDetailsService proxiedUserDetailsService;
    private KerberosTicketValidator ticketValidator;

    @Inject
    public OBDPKerberosAuthenticationProvider(AmbariAuthToLocalUserDetailsService authToLocalUserDetailsService, OBDPProxiedUserDetailsService proxiedUserDetailsService, KerberosTicketValidator ticketValidator) {
        this.authToLocalUserDetailsService = authToLocalUserDetailsService;
        this.proxiedUserDetailsService = proxiedUserDetailsService;
        this.ticketValidator = ticketValidator;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication == null) {
            throw new BadCredentialsException("Missing credentials");
        }
        if (authentication instanceof KerberosServiceRequestToken) {
            UserDetails userDetails;
            KerberosServiceRequestToken auth = (KerberosServiceRequestToken)authentication;
            byte[] token = auth.getToken();
            LOG.debug("Validating Kerberos token");
            KerberosTicketValidation ticketValidation = this.ticketValidator.validateTicket(token);
            LOG.debug("Kerberos token validated: {}", (Object)ticketValidation.username());
            Object requestDetails = authentication.getDetails();
            if (requestDetails instanceof TrustedProxyAuthenticationDetails) {
                TrustedProxyAuthenticationDetails trustedProxyAuthenticationDetails = (TrustedProxyAuthenticationDetails)((Object)requestDetails);
                String proxiedUserName = trustedProxyAuthenticationDetails.getDoAs();
                if (StringUtils.isNotEmpty((String)proxiedUserName)) {
                    String localProxyUserName = this.authToLocalUserDetailsService.translatePrincipalName(ticketValidation.username());
                    userDetails = new AmbariProxiedUserDetailsImpl(this.proxiedUserDetailsService.loadProxiedUser(proxiedUserName, localProxyUserName, trustedProxyAuthenticationDetails), new AmbariProxyUserKerberosDetailsImpl(ticketValidation.username(), localProxyUserName));
                } else {
                    userDetails = this.authToLocalUserDetailsService.loadUserByUsername(ticketValidation.username());
                }
            } else {
                userDetails = this.authToLocalUserDetailsService.loadUserByUsername(ticketValidation.username());
            }
            KerberosServiceRequestToken responseAuth = new KerberosServiceRequestToken((Object)userDetails, ticketValidation, userDetails.getAuthorities(), token);
            responseAuth.setDetails(requestDetails);
            return responseAuth;
        }
        throw new BadCredentialsException(String.format("Unexpected Authentication class: %s", authentication.getClass().getName()));
    }

    public boolean supports(Class<? extends Object> auth) {
        return KerberosServiceRequestToken.class.isAssignableFrom(auth);
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setAuthToLocalUserDetailsService(AmbariAuthToLocalUserDetailsService authToLocalUserDetailsService) {
        this.authToLocalUserDetailsService = authToLocalUserDetailsService;
    }

    public void setProxiedUserDetailsService(OBDPProxiedUserDetailsService proxiedUserDetailsService) {
        this.proxiedUserDetailsService = proxiedUserDetailsService;
    }

    public void setTicketValidator(KerberosTicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }
}

