/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.kerberos;

import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationException;
import id.onyx.obdp.server.security.authentication.OBDPAuthenticationEventHandler;
import id.onyx.obdp.server.security.authentication.OBDPAuthenticationFilter;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariKerberosAuthenticationProperties;
import id.onyx.obdp.server.security.authentication.tproxy.TrustedProxyAuthenticationDetailsSource;
import id.onyx.obdp.server.utils.RequestUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.kerberos.web.authentication.SpnegoAuthenticationProcessingFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class OBDPKerberosAuthenticationFilter
extends SpnegoAuthenticationProcessingFilter
implements OBDPAuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPKerberosAuthenticationFilter.class);
    private final OBDPAuthenticationEventHandler eventHandler;
    private final boolean kerberosAuthenticationEnabled;

    public OBDPKerberosAuthenticationFilter(AuthenticationManager authenticationManager, final AuthenticationEntryPoint entryPoint, Configuration configuration, final OBDPAuthenticationEventHandler eventHandler) {
        AmbariKerberosAuthenticationProperties kerberosAuthenticationProperties = configuration == null ? null : configuration.getKerberosAuthenticationProperties();
        boolean bl = this.kerberosAuthenticationEnabled = kerberosAuthenticationProperties != null && kerberosAuthenticationProperties.isKerberosAuthenticationEnabled();
        if (eventHandler == null) {
            throw new IllegalArgumentException("The OBDPAuthenticationEventHandler must not be null");
        }
        this.eventHandler = eventHandler;
        this.setAuthenticationManager(authenticationManager);
        this.setAuthenticationDetailsSource(new TrustedProxyAuthenticationDetailsSource());
        this.setFailureHandler(new AuthenticationFailureHandler(){

            public void onAuthenticationFailure(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationException e) throws IOException, ServletException {
                AmbariAuthenticationException cause = e instanceof AmbariAuthenticationException ? (AmbariAuthenticationException)e : new AmbariAuthenticationException(null, e.getLocalizedMessage(), false, e);
                eventHandler.onUnsuccessfulAuthentication(OBDPKerberosAuthenticationFilter.this, httpServletRequest, httpServletResponse, cause);
                entryPoint.commence(httpServletRequest, httpServletResponse, e);
            }
        });
        this.setSuccessHandler(new AuthenticationSuccessHandler(){

            public void onAuthenticationSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) throws IOException, ServletException {
                eventHandler.onSuccessfulAuthentication(OBDPKerberosAuthenticationFilter.this, httpServletRequest, httpServletResponse, authentication);
            }
        });
    }

    @Override
    public boolean shouldApply(HttpServletRequest httpServletRequest) {
        if (LOG.isDebugEnabled()) {
            RequestUtils.logRequestHeadersAndQueryParams(httpServletRequest, LOG);
        }
        if (this.kerberosAuthenticationEnabled) {
            String header = httpServletRequest.getHeader("Authorization");
            return header != null && (header.startsWith("Negotiate ") || header.startsWith("Kerberos "));
        }
        return false;
    }

    @Override
    public boolean shouldIncrementFailureCount() {
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.eventHandler != null) {
            this.eventHandler.beforeAttemptAuthentication(this, (ServletRequest)request, (ServletResponse)response);
        }
        super.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
    }
}

