/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.kerberos;

import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariKerberosAuthenticationProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;
import org.springframework.stereotype.Component;

@Component
public class AmbariKerberosTicketValidator
implements KerberosTicketValidator,
InitializingBean {
    private final SunJaasKerberosTicketValidator kerberosTicketValidator;

    public AmbariKerberosTicketValidator(Configuration configuration) {
        AmbariKerberosAuthenticationProperties properties;
        AmbariKerberosAuthenticationProperties ambariKerberosAuthenticationProperties = properties = configuration == null ? null : configuration.getKerberosAuthenticationProperties();
        if (properties != null && properties.isKerberosAuthenticationEnabled()) {
            this.kerberosTicketValidator = new SunJaasKerberosTicketValidator();
            this.kerberosTicketValidator.setServicePrincipal(properties.getSpnegoPrincipalName());
            if (properties.getSpnegoKeytabFilePath() != null) {
                this.kerberosTicketValidator.setKeyTabLocation((Resource)new FileSystemResource(properties.getSpnegoKeytabFilePath()));
            }
        } else {
            this.kerberosTicketValidator = null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.kerberosTicketValidator != null) {
            this.kerberosTicketValidator.afterPropertiesSet();
        }
    }

    public KerberosTicketValidation validateTicket(byte[] bytes) throws BadCredentialsException {
        return this.kerberosTicketValidator == null ? null : this.kerberosTicketValidator.validateTicket(bytes);
    }

    public void setDebug(boolean debug) {
        if (this.kerberosTicketValidator != null) {
            this.kerberosTicketValidator.setDebug(debug);
        }
    }
}

