/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.kerberos;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authentication.AccountDisabledException;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationException;
import id.onyx.obdp.server.security.authentication.InvalidUsernamePasswordCombinationException;
import id.onyx.obdp.server.security.authentication.OBDPUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.TooManyLoginFailuresException;
import id.onyx.obdp.server.security.authentication.UserNotFoundException;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariKerberosAuthenticationProperties;
import id.onyx.obdp.server.security.authorization.User;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class AmbariAuthToLocalUserDetailsService
implements UserDetailsService {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariAuthToLocalUserDetailsService.class);
    private final Configuration configuration;
    private final Users users;
    private final String authToLocalRules;

    AmbariAuthToLocalUserDetailsService(Configuration configuration, Users users) {
        AmbariKerberosAuthenticationProperties properties = configuration.getKerberosAuthenticationProperties();
        String authToLocalRules = properties.getAuthToLocalRules();
        if (StringUtils.isEmpty((String)authToLocalRules)) {
            authToLocalRules = "DEFAULT";
        }
        this.configuration = configuration;
        this.users = users;
        this.authToLocalRules = authToLocalRules;
    }

    public UserDetails loadUserByUsername(String principal) throws UsernameNotFoundException {
        Collection<UserAuthenticationEntity> entities = this.users.getUserAuthenticationEntities(UserAuthenticationType.KERBEROS, principal);
        if (CollectionUtils.isEmpty(entities)) {
            String username = this.translatePrincipalName(principal);
            if (username == null) {
                String message = String.format("Failed to translate %s to a local username during Kerberos authentication.", principal);
                LOG.warn(message);
                throw new UsernameNotFoundException(message);
            }
            LOG.info("Translated {} to {} using auth-to-local rules during Kerberos authentication.", (Object)principal, (Object)username);
            return this.createUser(username, principal);
        }
        if (entities.size() == 1) {
            UserEntity userEntity = entities.iterator().next().getUser();
            LOG.trace("Found KERBEROS authentication method for {} using principal {}", (Object)userEntity.getUserName(), (Object)principal);
            return this.createUserDetails(userEntity);
        }
        throw new AmbariAuthenticationException("", "Unexpected error due to collisions on the principal name", false);
    }

    private UserDetails createUser(String username, String principal) throws AuthenticationException {
        UserEntity userEntity = this.users.getUserEntity(username);
        if (userEntity == null) {
            LOG.info("User not found: {} (from {})", (Object)username, (Object)principal);
            throw new UserNotFoundException(username, String.format("Cannot find user using Kerberos ticket (%s).", principal));
        }
        List<UserAuthenticationEntity> authenticationEntities = userEntity.getAuthenticationEntities();
        boolean hasKerberos = false;
        for (UserAuthenticationEntity entity : authenticationEntities) {
            UserAuthenticationType authenticationType = entity.getAuthenticationType();
            switch (authenticationType) {
                case KERBEROS: {
                    String key = entity.getAuthenticationKey();
                    if (StringUtils.isEmpty((String)key) || key.equals(username)) {
                        LOG.trace("Found KERBEROS authentication method for {} where no principal was set. Fixing...", (Object)username);
                        try {
                            this.users.addKerberosAuthentication(userEntity, principal);
                            this.users.removeAuthentication(userEntity, entity.getUserAuthenticationId());
                        }
                        catch (OBDPException e) {
                            LOG.warn(String.format("Failed to create KERBEROS authentication method entry for %s with principal %s: %s", username, principal, e.getLocalizedMessage()), (Throwable)e);
                        }
                        hasKerberos = true;
                        break;
                    }
                    if (!principal.equalsIgnoreCase(entity.getAuthenticationKey())) break;
                    LOG.trace("Found KERBEROS authentication method for {} using principal {}", (Object)username, (Object)principal);
                    hasKerberos = true;
                }
            }
            if (!hasKerberos) continue;
            break;
        }
        if (!hasKerberos) {
            try {
                this.users.addKerberosAuthentication(userEntity, principal);
                LOG.trace("Added KERBEROS authentication method for {} using principal {}", (Object)username, (Object)principal);
            }
            catch (OBDPException e) {
                LOG.error(String.format("Failed to add the KERBEROS authentication method for %s: %s", principal, e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return this.createUserDetails(userEntity);
    }

    private UserDetails createUserDetails(UserEntity userEntity) {
        String username = userEntity.getUserName();
        try {
            this.users.validateLogin(userEntity, username);
        }
        catch (AccountDisabledException | TooManyLoginFailuresException e) {
            if (this.configuration.showLockedOutUserMessage()) {
                throw e;
            }
            throw new InvalidUsernamePasswordCombinationException(username, false, (Throwable)((Object)e));
        }
        return new OBDPUserDetailsImpl(new User(userEntity), null, this.users.getUserAuthorities(userEntity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String translatePrincipalName(String principalName) {
        if (StringUtils.isNotEmpty((String)principalName) && principalName.contains("@")) {
            try {
                Class<KerberosName> clazz = KerberosName.class;
                synchronized (KerberosName.class) {
                    KerberosName.setRules((String)this.authToLocalRules);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return new KerberosName(principalName).getShortName();
                }
            }
            catch (UserNotFoundException e) {
                throw new UsernameNotFoundException(e.getMessage(), (Throwable)((Object)e));
            }
            catch (IOException e) {
                String message = String.format("Failed to translate %s to a local username during Kerberos authentication: %s", principalName, e.getLocalizedMessage());
                LOG.warn(message);
                throw new UsernameNotFoundException(message, (Throwable)e);
            }
        }
        return principalName;
    }
}

