/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.jwt;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authentication.AccountDisabledException;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationException;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationProvider;
import id.onyx.obdp.server.security.authentication.OBDPUserAuthentication;
import id.onyx.obdp.server.security.authentication.OBDPUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.TooManyLoginFailuresException;
import id.onyx.obdp.server.security.authentication.UserNotFoundException;
import id.onyx.obdp.server.security.authentication.jwt.JwtAuthenticationToken;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class OBDPJwtAuthenticationProvider
extends AmbariAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPJwtAuthenticationProvider.class);

    @Inject
    public OBDPJwtAuthenticationProvider(Users users, Configuration configuration) {
        super(users, configuration);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication.getName() == null) {
            LOG.info("Authentication failed: no username provided");
            throw new AmbariAuthenticationException(null, "Unexpected error due to missing username", false);
        }
        String userName = authentication.getName().trim();
        if (authentication.getCredentials() == null) {
            LOG.info("Authentication failed: no credentials provided: {}", (Object)userName);
            throw new AmbariAuthenticationException(userName, "Unexpected error due to missing JWT token", false);
        }
        Users users = this.getUsers();
        UserEntity userEntity = users.getUserEntity(userName);
        if (userEntity == null) {
            LOG.info("User not found: {}", (Object)userName);
            throw new UserNotFoundException(userName, "Cannot find user from JWT. Please, ensure LDAP is configured and users are synced.");
        }
        boolean authOK = false;
        UserAuthenticationEntity authenticationEntity = this.getAuthenticationEntity(userEntity, UserAuthenticationType.JWT);
        if (authenticationEntity != null) {
            authOK = true;
        } else {
            authenticationEntity = this.getAuthenticationEntity(userEntity, UserAuthenticationType.LDAP);
            if (authenticationEntity != null) {
                try {
                    users.addJWTAuthentication(userEntity, userName);
                    authOK = true;
                }
                catch (OBDPException e) {
                    LOG.error(String.format("Failed to add the JWT authentication method for %s: %s", userName, e.getLocalizedMessage()), (Throwable)e);
                    throw new AmbariAuthenticationException(userName, "Unexpected error has occurred", false, e);
                }
            }
        }
        if (authOK) {
            LOG.debug("Authentication succeeded - a matching user was found: {}", (Object)userName);
            try {
                users.validateLogin(userEntity, userName);
            }
            catch (AccountDisabledException | TooManyLoginFailuresException e) {
                if (this.getConfiguration().showLockedOutUserMessage()) {
                    throw e;
                }
                throw new AmbariAuthenticationException(userName, "Unexpected error due to missing JWT token", false);
            }
            OBDPUserDetailsImpl userDetails = new OBDPUserDetailsImpl(users.getUser(userEntity), null, users.getUserAuthorities(userEntity));
            String jwtTokenName = userDetails.getUsername().trim();
            if (!userName.equals(jwtTokenName)) {
                AuthorizationHelper.addLoginNameAlias(userName, jwtTokenName);
            }
            return new OBDPUserAuthentication(authentication.getCredentials().toString(), userDetails, true);
        }
        LOG.debug("Authentication failed: password does not match stored value: {}", (Object)userName);
        throw new UserNotFoundException(userName, "Cannot find user from JWT. Please, ensure LDAP is configured and users are synced.");
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

