/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication.jwt;

import id.onyx.obdp.server.configuration.OBDPServerConfiguration;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.security.authentication.jwt.JwtAuthenticationPropertiesProvider;
import id.onyx.obdp.server.security.encryption.CertificateUtils;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthenticationProperties
extends OBDPServerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(JwtAuthenticationPropertiesProvider.class);
    private static final String PEM_CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_CERTIFICATE_FOOTER = "-----END CERTIFICATE-----";
    private RSAPublicKey publicKey = null;

    JwtAuthenticationProperties(Map<String, String> configurationMap) {
        super(configurationMap);
    }

    @Override
    protected OBDPServerConfigurationCategory getCategory() {
        return OBDPServerConfigurationCategory.SSO_CONFIGURATION;
    }

    public String getAuthenticationProviderUrl() {
        return this.getValue(OBDPServerConfigurationKey.SSO_PROVIDER_URL, this.configurationMap);
    }

    public String getCertification() {
        return this.getValue(OBDPServerConfigurationKey.SSO_PROVIDER_CERTIFICATE, this.configurationMap);
    }

    public RSAPublicKey getPublicKey() {
        if (this.publicKey == null) {
            this.publicKey = this.createPublicKey(this.getCertification());
        }
        return this.publicKey;
    }

    void setPublicKey(RSAPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public List<String> getAudiences() {
        ArrayList audiences;
        String audiencesString = this.getValue(OBDPServerConfigurationKey.SSO_JWT_AUDIENCES, this.configurationMap);
        if (StringUtils.isNotEmpty((String)audiencesString)) {
            String[] audArray = audiencesString.split(",");
            audiences = new ArrayList();
            Collections.addAll(audiences, audArray);
        } else {
            audiences = null;
        }
        return audiences;
    }

    public String getCookieName() {
        return this.getValue(OBDPServerConfigurationKey.SSO_JWT_COOKIE_NAME, this.configurationMap);
    }

    public String getOriginalUrlQueryParam() {
        return this.getValue(OBDPServerConfigurationKey.SSO_PROVIDER_ORIGINAL_URL_PARAM_NAME, this.configurationMap);
    }

    public boolean isEnabledForAmbari() {
        return Boolean.valueOf(this.getValue(OBDPServerConfigurationKey.SSO_AUTHENTICATION_ENABLED, this.configurationMap));
    }

    private RSAPublicKey createPublicKey(String certificate) {
        RSAPublicKey publicKey = null;
        if (certificate != null) {
            certificate = ((String)certificate).trim();
        }
        if (!StringUtils.isEmpty((String)certificate)) {
            if (!((String)certificate).startsWith(PEM_CERTIFICATE_HEADER)) {
                certificate = "-----BEGIN CERTIFICATE-----/n" + (String)certificate;
            }
            if (!((String)certificate).endsWith(PEM_CERTIFICATE_FOOTER)) {
                certificate = (String)certificate + "/n-----END CERTIFICATE-----";
            }
            try {
                publicKey = CertificateUtils.getPublicKeyFromString((String)certificate);
            }
            catch (UnsupportedEncodingException | CertificateException e) {
                LOG.error("Unable to parse public certificate file. JTW authentication will fail.", (Throwable)e);
            }
        }
        return publicKey;
    }

    @Override
    public Map<String, String> toMap() {
        return this.configurationMap;
    }
}

