/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import com.fasterxml.jackson.annotation.JsonIgnore;
import id.onyx.obdp.server.security.authentication.OBDPUserDetails;
import java.util.Collection;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class OBDPUserAuthentication
implements Authentication {
    private final String serializedToken;
    private final OBDPUserDetails userDetails;
    private boolean authenticated;

    public OBDPUserAuthentication(String token, OBDPUserDetails userDetails) {
        this(token, userDetails, false);
    }

    public OBDPUserAuthentication(String token, OBDPUserDetails userDetails, boolean authenticated) {
        this.serializedToken = token;
        this.userDetails = userDetails;
        this.authenticated = authenticated;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.userDetails == null ? null : this.userDetails.getAuthorities();
    }

    public String getCredentials() {
        return this.serializedToken;
    }

    public Object getDetails() {
        return null;
    }

    public OBDPUserDetails getPrincipal() {
        return this.userDetails;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) throws IllegalArgumentException {
        this.authenticated = authenticated;
    }

    public String getName() {
        return this.userDetails == null ? null : this.userDetails.getUsername();
    }

    public Integer getUserId() {
        return this.userDetails == null ? null : this.userDetails.getUserId();
    }
}

