/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authentication.AccountDisabledException;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationProvider;
import id.onyx.obdp.server.security.authentication.InvalidUsernamePasswordCombinationException;
import id.onyx.obdp.server.security.authentication.OBDPUserAuthentication;
import id.onyx.obdp.server.security.authentication.OBDPUserDetailsImpl;
import id.onyx.obdp.server.security.authentication.TooManyLoginFailuresException;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class OBDPLocalAuthenticationProvider
extends AmbariAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPLocalAuthenticationProvider.class);
    private PasswordEncoder passwordEncoder;

    @Inject
    public OBDPLocalAuthenticationProvider(Users users, PasswordEncoder passwordEncoder, Configuration configuration) {
        super(users, configuration);
        this.passwordEncoder = passwordEncoder;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication.getName() == null) {
            LOG.info("Authentication failed: no username provided");
            throw new InvalidUsernamePasswordCombinationException("");
        }
        String userName = authentication.getName().trim();
        if (authentication.getCredentials() == null) {
            LOG.info("Authentication failed: no credentials provided: {}", (Object)userName);
            throw new InvalidUsernamePasswordCombinationException(userName);
        }
        Users users = this.getUsers();
        UserEntity userEntity = users.getUserEntity(userName);
        if (userEntity == null) {
            LOG.info("User not found: {}", (Object)userName);
            throw new InvalidUsernamePasswordCombinationException(userName);
        }
        UserAuthenticationEntity authenticationEntity = this.getAuthenticationEntity(userEntity, UserAuthenticationType.LOCAL);
        if (authenticationEntity != null) {
            String password = authenticationEntity.getAuthenticationKey();
            String presentedPassword = authentication.getCredentials().toString();
            if (this.passwordEncoder.matches((CharSequence)presentedPassword, password)) {
                LOG.debug("Authentication succeeded - a matching username and password were found: {}", (Object)userName);
                try {
                    users.validateLogin(userEntity, userName);
                }
                catch (AccountDisabledException | TooManyLoginFailuresException e) {
                    if (this.getConfiguration().showLockedOutUserMessage()) {
                        throw e;
                    }
                    throw new InvalidUsernamePasswordCombinationException(userName, false, (Throwable)((Object)e));
                }
                OBDPUserDetailsImpl userDetails = new OBDPUserDetailsImpl(users.getUser(userEntity), password, users.getUserAuthorities(userEntity));
                return new OBDPUserAuthentication(password, userDetails, true);
            }
        }
        LOG.debug("Authentication failed: password does not match stored value: {}", (Object)userName);
        throw new InvalidUsernamePasswordCombinationException(userName);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

