/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import id.onyx.obdp.server.security.authentication.OBDPAuthenticationFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OBDPDelegatingAuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPDelegatingAuthenticationFilter.class);
    private final Collection<OBDPAuthenticationFilter> filters;

    public OBDPDelegatingAuthenticationFilter(Collection<OBDPAuthenticationFilter> filters) {
        Collection<Object> collection = this.filters = filters == null ? Collections.emptyList() : filters;
        if (this.filters.isEmpty()) {
            LOG.warn("The delegated filters list is empty. No authentication tests will be performed by this authentication filter.");
        } else if (LOG.isDebugEnabled()) {
            StringBuffer filterNames = new StringBuffer();
            for (OBDPAuthenticationFilter filter : this.filters) {
                filterNames.append("\n\t");
                filterNames.append(filter.getClass().getName());
            }
            LOG.debug("This authentication filter will attempt to authenticate a user using one of the following delegated authentication filters: {}", (Object)filterNames);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        for (OBDPAuthenticationFilter filter : this.filters) {
            filter.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        boolean handled = false;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        for (OBDPAuthenticationFilter filter : this.filters) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Attempting to apply authentication filter {}", (Object)filter.getClass().getName());
            }
            if (filter.shouldApply(httpServletRequest)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using authentication filter {} since it applies", (Object)filter.getClass().getName());
                }
                filter.doFilter(servletRequest, servletResponse, chain);
                handled = true;
                break;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Filter {} does not apply skipping", (Object)filter.getClass().getName());
        }
        if (!handled) {
            LOG.debug("No delegated filters applied while attempting to authenticate a user, continuing with the filter chain.");
            chain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        for (OBDPAuthenticationFilter filter : this.filters) {
            filter.destroy();
        }
    }
}

