/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import id.onyx.obdp.server.security.AmbariEntryPoint;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationException;
import id.onyx.obdp.server.security.authentication.OBDPAuthenticationEventHandler;
import id.onyx.obdp.server.security.authentication.OBDPAuthenticationFilter;
import id.onyx.obdp.server.utils.RequestUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
public class OBDPBasicAuthenticationFilter
extends BasicAuthenticationFilter
implements OBDPAuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPBasicAuthenticationFilter.class);
    private final OBDPAuthenticationEventHandler eventHandler;

    public OBDPBasicAuthenticationFilter(AuthenticationManager authenticationManager, AmbariEntryPoint ambariEntryPoint, OBDPAuthenticationEventHandler eventHandler) {
        super(authenticationManager, (AuthenticationEntryPoint)ambariEntryPoint);
        if (eventHandler == null) {
            throw new IllegalArgumentException("The OBDPAuthenticationEventHandler must not be null");
        }
        this.eventHandler = eventHandler;
    }

    @Override
    public boolean shouldApply(HttpServletRequest httpServletRequest) {
        String header;
        if (LOG.isDebugEnabled()) {
            RequestUtils.logRequestHeadersAndQueryParams(httpServletRequest, LOG);
        }
        if ((header = httpServletRequest.getHeader("Authorization")) != null && header.startsWith("Basic ")) {
            String doAsQueryParameterValue = RequestUtils.getQueryStringParameterValue(httpServletRequest, "doAs");
            if (StringUtils.isEmpty((String)doAsQueryParameterValue)) {
                return true;
            }
            LOG.warn("The 'doAs' query parameter was provided; however, the BasicAuth header is found. Ignoring the BasicAuth header hoping to negotiate Kerberos authentication.");
            return false;
        }
        return false;
    }

    @Override
    public boolean shouldIncrementFailureCount() {
        return true;
    }

    public void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.eventHandler != null) {
            this.eventHandler.beforeAttemptAuthentication(this, (ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        super.doFilterInternal(httpServletRequest, httpServletResponse, filterChain);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Authentication authResult) throws IOException {
        if (this.eventHandler != null) {
            this.eventHandler.onSuccessfulAuthentication(this, servletRequest, servletResponse, authResult);
        }
    }

    protected void onUnsuccessfulAuthentication(HttpServletRequest servletRequest, HttpServletResponse servletResponse, AuthenticationException authException) throws IOException {
        if (this.eventHandler != null) {
            AmbariAuthenticationException cause;
            if (authException instanceof AmbariAuthenticationException) {
                cause = (AmbariAuthenticationException)authException;
            } else {
                String header = servletRequest.getHeader("Authorization");
                String username = null;
                try {
                    username = this.getUsernameFromAuth(header, this.getCredentialsCharset(servletRequest));
                }
                catch (Exception e) {
                    LOG.warn("Error occurred during decoding authorization header.", (Throwable)e);
                }
                cause = new AmbariAuthenticationException(username, authException.getMessage(), false, authException);
            }
            this.eventHandler.onUnsuccessfulAuthentication(this, servletRequest, servletResponse, cause);
        }
    }

    private String getUsernameFromAuth(String authenticationValue, String charSet) throws IOException {
        byte[] decoded;
        byte[] base64Token = authenticationValue.substring(6).getBytes("UTF-8");
        try {
            decoded = Base64.decode((byte[])base64Token);
        }
        catch (IllegalArgumentException ex) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, charSet);
        int delimiter = token.indexOf(":");
        if (delimiter == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return token.substring(0, delimiter);
    }
}

