/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.LoginAuditEvent;
import id.onyx.obdp.server.security.authentication.AmbariAuthenticationException;
import id.onyx.obdp.server.security.authentication.OBDPAuthenticationEventHandler;
import id.onyx.obdp.server.security.authentication.OBDPAuthenticationFilter;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.PermissionHelper;
import id.onyx.obdp.server.security.authorization.Users;
import id.onyx.obdp.server.utils.RequestUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

@Singleton
public class OBDPAuthenticationEventHandlerImpl
implements OBDPAuthenticationEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPAuthenticationEventHandlerImpl.class);
    @Inject
    private AuditLogger auditLogger;
    @Inject
    private PermissionHelper permissionHelper;
    @Inject
    private Users users;

    @Override
    public void onSuccessfulAuthentication(OBDPAuthenticationFilter filter, HttpServletRequest servletRequest, HttpServletResponse servletResponse, Authentication result) {
        String username;
        String string = username = result == null ? null : result.getName();
        if (this.auditLogger.isEnabled()) {
            AuditEvent loginSucceededAuditEvent = ((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)LoginAuditEvent.builder().withRemoteIp(RequestUtils.getRemoteAddress(servletRequest))).withUserName(username)).withProxyUserName(AuthorizationHelper.getProxyUserName(result))).withTimestamp(System.currentTimeMillis())).withRoles(this.permissionHelper.getPermissionLabels(result)).build();
            this.auditLogger.log(loginSucceededAuditEvent);
        }
        if (!StringUtils.isEmpty((String)username)) {
            LOG.debug("Successfully authenticated {}", (Object)username);
            this.users.clearConsecutiveAuthenticationFailures(username);
        } else {
            LOG.warn("Successfully authenticated an unknown user");
        }
    }

    @Override
    public void onUnsuccessfulAuthentication(OBDPAuthenticationFilter filter, HttpServletRequest servletRequest, HttpServletResponse servletResponse, AmbariAuthenticationException cause) {
        boolean incrementFailureCount;
        String message;
        String username;
        Integer consecutiveFailures = null;
        if (cause == null) {
            username = null;
            message = "Unknown cause";
            incrementFailureCount = false;
        } else {
            username = cause.getUsername();
            message = cause.getLocalizedMessage();
            incrementFailureCount = cause.isCredentialFailure();
        }
        String logMessage = !StringUtils.isEmpty((String)username) ? (incrementFailureCount && filter.shouldIncrementFailureCount() ? ((consecutiveFailures = this.users.incrementConsecutiveAuthenticationFailures(username)) == null ? String.format("Failed to authenticate %s: The user does not exist in the Ambari database", username) : String.format("Failed to authenticate %s (attempt #%d): %s", username, consecutiveFailures, message)) : String.format("Failed to authenticate %s: %s", username, message)) : String.format("Failed to authenticate an unknown user: %s", message);
        if (LOG.isDebugEnabled()) {
            LOG.debug(logMessage, (Throwable)((Object)cause));
        } else {
            LOG.info(logMessage);
        }
        if (this.auditLogger.isEnabled()) {
            AuditEvent loginFailedAuditEvent = ((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)LoginAuditEvent.builder().withRemoteIp(RequestUtils.getRemoteAddress(servletRequest))).withTimestamp(System.currentTimeMillis())).withReasonOfFailure(message).withConsecutiveFailures(consecutiveFailures).withUserName(username)).withProxyUserName(null)).build();
            this.auditLogger.log(loginFailedAuditEvent);
        }
    }

    @Override
    public void beforeAttemptAuthentication(OBDPAuthenticationFilter filter, ServletRequest servletRequest, ServletResponse servletResponse) {
    }
}

