/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.orm.DBAccessor;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapToPamMigrationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LdapToPamMigrationHelper.class);
    @Inject
    private DBAccessor dbAccessor;

    private void migrateLdapUsersGroups() throws SQLException {
        if (this.dbAccessor.getDbType() != DBAccessor.DbType.ORACLE) {
            this.dbAccessor.executeQuery("UPDATE users SET user_type='PAM',ldap_user=0 WHERE ldap_user=1 and user_name not in (select user_name from (select user_name from users where user_type = 'PAM') as a)");
            this.dbAccessor.executeQuery("UPDATE groups SET group_type='PAM',ldap_group=0 WHERE ldap_group=1 and group_name not in (select group_name from (select group_name from groups where group_type = 'PAM') as a)");
        } else {
            this.dbAccessor.executeQuery("UPDATE users SET user_type='PAM',ldap_user=0 WHERE ldap_user=1 and user_name not in (select user_name from users where user_type = 'PAM')");
            this.dbAccessor.executeQuery("UPDATE groups SET group_type='PAM',ldap_group=0 WHERE ldap_group=1 and group_name not in (select group_name from groups where group_type = 'PAM')");
        }
    }

    public static void main(String[] args) {
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{new ControllerModule(), new AuditLoggerModule()});
            LdapToPamMigrationHelper migrationHelper = (LdapToPamMigrationHelper)injector.getInstance(LdapToPamMigrationHelper.class);
            migrationHelper.migrateLdapUsersGroups();
        }
        catch (Throwable t) {
            LOG.error("Caught exception on migration. Exiting...", t);
            System.exit(1);
        }
    }
}

