/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import org.springframework.security.core.AuthenticationException;

public class AuthenticationMethodNotAllowedException
extends AuthenticationException {
    private final String username;
    private final UserAuthenticationType userAuthenticationType;

    public AuthenticationMethodNotAllowedException(String username, UserAuthenticationType authenticationType) {
        this(username, authenticationType, AuthenticationMethodNotAllowedException.createDefaultMessage(username, authenticationType));
    }

    public AuthenticationMethodNotAllowedException(String username, UserAuthenticationType authenticationType, Throwable cause) {
        this(username, authenticationType, AuthenticationMethodNotAllowedException.createDefaultMessage(username, authenticationType), cause);
    }

    public AuthenticationMethodNotAllowedException(String username, UserAuthenticationType authenticationType, String message) {
        super(message);
        this.username = username;
        this.userAuthenticationType = authenticationType;
    }

    public AuthenticationMethodNotAllowedException(String username, UserAuthenticationType authenticationType, String message, Throwable cause) {
        super(message, cause);
        this.username = username;
        this.userAuthenticationType = authenticationType;
    }

    public String getUsername() {
        return this.username;
    }

    public UserAuthenticationType getUserAuthenticationType() {
        return this.userAuthenticationType;
    }

    private static String createDefaultMessage(String username, UserAuthenticationType authenticationType) {
        return String.format("%s is not authorized to authenticate using %s", username, authenticationType == null ? "null" : authenticationType.name());
    }
}

