/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authentication;

import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;

public abstract class AmbariAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AmbariAuthenticationProvider.class);
    private final Users users;
    private final Configuration configuration;

    protected AmbariAuthenticationProvider(Users users, Configuration configuration) {
        this.users = users;
        this.configuration = configuration;
    }

    protected UserAuthenticationEntity getAuthenticationEntity(UserEntity userEntity, UserAuthenticationType type) {
        List<UserAuthenticationEntity> authenticationEntities;
        List<UserAuthenticationEntity> list = authenticationEntities = userEntity == null ? null : userEntity.getAuthenticationEntities();
        if (authenticationEntities != null) {
            for (UserAuthenticationEntity authenticationEntity : authenticationEntities) {
                if (authenticationEntity.getAuthenticationType() != type) continue;
                return authenticationEntity;
            }
        }
        return null;
    }

    protected Collection<UserAuthenticationEntity> getAuthenticationEntities(UserEntity userEntity, UserAuthenticationType type) {
        List<UserAuthenticationEntity> authenticationEntities;
        ArrayList<UserAuthenticationEntity> foundAuthenticationEntities = null;
        List<UserAuthenticationEntity> list = authenticationEntities = userEntity == null ? null : userEntity.getAuthenticationEntities();
        if (authenticationEntities != null) {
            foundAuthenticationEntities = new ArrayList<UserAuthenticationEntity>();
            for (UserAuthenticationEntity authenticationEntity : authenticationEntities) {
                if (authenticationEntity.getAuthenticationType() != type) continue;
                foundAuthenticationEntities.add(authenticationEntity);
            }
        }
        return foundAuthenticationEntities;
    }

    protected Collection<UserAuthenticationEntity> getAuthenticationEntities(UserAuthenticationType type, String key) {
        return this.users.getUserAuthenticationEntities(type, key);
    }

    protected Users getUsers() {
        return this.users;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }
}

