/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security;

import id.onyx.obdp.server.configuration.Configuration;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityFilter
implements Filter {
    private static String CA = "/ca";
    private static Configuration config;
    private static final Logger LOG;

    public void destroy() {
    }

    public void doFilter(ServletRequest serReq, ServletResponse serResp, FilterChain filtCh) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)serReq;
        String reqUrl = req.getRequestURL().toString();
        LOG.debug("Filtering {} for security purposes", (Object)reqUrl);
        if (serReq.getLocalPort() != config.getTwoWayAuthPort()) {
            if (this.isRequestAllowed(reqUrl)) {
                filtCh.doFilter(serReq, serResp);
            } else {
                LOG.warn("This request is not allowed on this port: " + reqUrl);
            }
        } else {
            LOG.debug("Request can continue on secure port {}", (Object)serReq.getLocalPort());
            filtCh.doFilter(serReq, serResp);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private boolean isRequestAllowed(String reqUrl) {
        try {
            URL url = new URL(reqUrl);
            if (!"https".equals(url.getProtocol())) {
                LOG.warn(String.format("Request %s is not using HTTPS", reqUrl));
                return false;
            }
            if (Pattern.matches("/cert/ca(/?)", url.getPath())) {
                return true;
            }
            if (Pattern.matches("/connection_info", url.getPath())) {
                return true;
            }
            if (Pattern.matches("/certs/[^/0-9][^/]*", url.getPath())) {
                return true;
            }
            if (Pattern.matches("/resources/.*", url.getPath())) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while validating if request is secure " + e);
        }
        LOG.warn("Request " + reqUrl + " doesn't match any pattern.");
        return false;
    }

    public static void init(Configuration instance) {
        config = instance;
    }

    static {
        LOG = LoggerFactory.getLogger(SecurityFilter.class);
    }
}

