/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security;

import com.google.inject.Singleton;
import java.security.SecureRandom;
import java.util.ArrayList;

@Singleton
public class SecurePasswordHelper {
    public static final int DEFAULT_SECURE_PASSWORD_LENGTH = 18;
    public static final int DEFAULT_SECURE_PASSWORD_MIN_LOWERCASE_LETTERS = 1;
    public static final int DEFAULT_SECURE_PASSWORD_MIN_UPPERCASE_LETTERS = 1;
    public static final int DEFAULT_SECURE_PASSWORD_MIN_DIGITS = 1;
    public static final int DEFAULT_SECURE_PASSWORD_MIN_PUNCTUATION = 1;
    public static final int DEFAULT_SECURE_PASSWORD_MIN_WHITESPACE = 1;
    static final char[] SECURE_PASSWORD_CHARACTER_CLASS_LOWERCASE_LETTERS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    static final char[] SECURE_PASSWORD_CHARACTER_CLASS_UPPERCASE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    static final char[] SECURE_PASSWORD_CHARACTER_CLASS_DIGITS = "0123456789".toCharArray();
    static final char[] SECURE_PASSWORD_CHARACTER_CLASS_PUNCTUATION = "?.!$%^*()-_+=~".toCharArray();
    static final char[] SECURE_PASSWORD_CHARACTER_CLASS_WHITESPACE = " ".toCharArray();
    private static final char[][] SECURE_PASSWORD_CHARACTER_CLASSES = new char[][]{SECURE_PASSWORD_CHARACTER_CLASS_LOWERCASE_LETTERS, SECURE_PASSWORD_CHARACTER_CLASS_UPPERCASE_LETTERS, SECURE_PASSWORD_CHARACTER_CLASS_DIGITS, SECURE_PASSWORD_CHARACTER_CLASS_PUNCTUATION, SECURE_PASSWORD_CHARACTER_CLASS_WHITESPACE};
    private final SecureRandom secureRandom = new SecureRandom();

    public String createSecurePassword() {
        return this.createSecurePassword(null, null, null, null, null, null);
    }

    public String createSecurePassword(Integer length, Integer minLowercaseLetters, Integer minUppercaseLetters, Integer minDigits, Integer minPunctuation, Integer minWhitespace) {
        int i;
        if (length == null || length < 1) {
            length = 18;
        }
        if (minLowercaseLetters == null) {
            minLowercaseLetters = 1;
        }
        if (minUppercaseLetters == null) {
            minUppercaseLetters = 1;
        }
        if (minDigits == null) {
            minDigits = 1;
        }
        if (minPunctuation == null) {
            minPunctuation = 1;
        }
        if (minWhitespace == null) {
            minWhitespace = 1;
        }
        ArrayList<Character> characters = new ArrayList<Character>(length);
        for (i = 0; i < minLowercaseLetters; ++i) {
            characters.add(Character.valueOf(SECURE_PASSWORD_CHARACTER_CLASS_LOWERCASE_LETTERS[this.secureRandom.nextInt(SECURE_PASSWORD_CHARACTER_CLASS_LOWERCASE_LETTERS.length)]));
        }
        for (i = 0; i < minUppercaseLetters; ++i) {
            characters.add(Character.valueOf(SECURE_PASSWORD_CHARACTER_CLASS_UPPERCASE_LETTERS[this.secureRandom.nextInt(SECURE_PASSWORD_CHARACTER_CLASS_UPPERCASE_LETTERS.length)]));
        }
        for (i = 0; i < minDigits; ++i) {
            characters.add(Character.valueOf(SECURE_PASSWORD_CHARACTER_CLASS_DIGITS[this.secureRandom.nextInt(SECURE_PASSWORD_CHARACTER_CLASS_DIGITS.length)]));
        }
        for (i = 0; i < minPunctuation; ++i) {
            characters.add(Character.valueOf(SECURE_PASSWORD_CHARACTER_CLASS_PUNCTUATION[this.secureRandom.nextInt(SECURE_PASSWORD_CHARACTER_CLASS_PUNCTUATION.length)]));
        }
        for (i = 0; i < minWhitespace; ++i) {
            characters.add(Character.valueOf(SECURE_PASSWORD_CHARACTER_CLASS_WHITESPACE[this.secureRandom.nextInt(SECURE_PASSWORD_CHARACTER_CLASS_WHITESPACE.length)]));
        }
        if (characters.size() < length) {
            int difference = length - characters.size();
            for (int i2 = 0; i2 < difference; ++i2) {
                char[] characterClass = SECURE_PASSWORD_CHARACTER_CLASSES[this.secureRandom.nextInt(SECURE_PASSWORD_CHARACTER_CLASSES.length - 1)];
                characters.add(Character.valueOf(characterClass[this.secureRandom.nextInt(characterClass.length)]));
            }
        }
        StringBuilder passwordBuilder = new StringBuilder(characters.size());
        while (!characters.isEmpty()) {
            passwordBuilder.append(characters.remove(this.secureRandom.nextInt(characters.size())));
        }
        return passwordBuilder.toString();
    }
}

