/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.SignCertResponse;
import id.onyx.obdp.server.utils.HostUtils;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CertificateManager {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateManager.class);
    @Inject
    Configuration configs;
    private static final String GEN_SRVR_KEY = "openssl genrsa -des3 -passout pass:{0} -out {1}" + File.separator + "{2} 4096 ";
    private static final String GEN_SRVR_REQ = "openssl req -passin pass:{0} -new -key {1}" + File.separator + "{2} -out {1}" + File.separator + "{5} -batch";
    private static final String SIGN_SRVR_CRT = "openssl ca -create_serial -out {1}" + File.separator + "{3} -days 365 -keyfile {1}" + File.separator + "{2} -key {0} -selfsign -extensions jdk7_ca -config {1}" + File.separator + "ca.config -batch -infiles {1}" + File.separator + "{5}";
    private static final String EXPRT_KSTR = "openssl pkcs12 -export -in {1}" + File.separator + "{3} -inkey {1}" + File.separator + "{2} -certfile {1}" + File.separator + "{3} -out {1}" + File.separator + "{4} -password pass:{0} -passin pass:{0} \n";
    private static final String REVOKE_AGENT_CRT = "openssl ca -config {0}" + File.separator + "ca.config -keyfile {0}" + File.separator + "{4} -revoke {0}" + File.separator + "{2} -batch -passin pass:{3} -cert {0}" + File.separator + "{5}";
    private static final String SIGN_AGENT_CRT = "openssl ca -config {0}" + File.separator + "ca.config -in {0}" + File.separator + "{1} -out {0}" + File.separator + "{2} -batch -passin pass:{3} -keyfile {0}" + File.separator + "{4} -cert {0}" + File.separator + "{5}";
    private static final String SET_PERMISSIONS = "find %s -type f -exec chmod 700 {} +";
    private static final String SET_SERVER_PASS_FILE_PERMISSIONS = "chmod 600 %s";

    public void initRootCert() {
        LOG.info("Initialization of root certificate");
        boolean certExists = this.isCertExists();
        LOG.info("Certificate exists:" + certExists);
        if (!certExists) {
            this.generateServerCertificate();
        }
    }

    private boolean isCertExists() {
        Map<String, String> configsMap = this.configs.getConfigsMap();
        String srvrKstrDir = configsMap.get(Configuration.SRVR_KSTR_DIR.getKey());
        String srvrCrtName = configsMap.get(Configuration.SRVR_CRT_NAME.getKey());
        File certFile = new File(srvrKstrDir + File.separator + srvrCrtName);
        LOG.debug("srvrKstrDir = {}", (Object)srvrKstrDir);
        LOG.debug("srvrCrtName = {}", (Object)srvrCrtName);
        LOG.debug("certFile = {}", (Object)certFile.getAbsolutePath());
        return certFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int runCommand(String command) {
        String line = null;
        Process process = null;
        BufferedReader br = null;
        try {
            process = Runtime.getRuntime().exec(command);
            br = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF8")));
            while ((line = br.readLine()) != null) {
                LOG.info(line);
            }
            try {
                process.waitFor();
                ShellCommandUtil.logOpenSslExitCode(command, process.exitValue());
                int n = process.exitValue();
                return n;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                if (br == null) return -1;
                try {
                    br.close();
                    return -1;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return -1;
                catch (IOException e2) {
                    e2.printStackTrace();
                    return -1;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    private void generateServerCertificate() {
        LOG.info("Generation of server certificate");
        Map<String, String> configsMap = this.configs.getConfigsMap();
        String srvrKstrDir = configsMap.get(Configuration.SRVR_KSTR_DIR.getKey());
        String srvrCrtName = configsMap.get(Configuration.SRVR_CRT_NAME.getKey());
        String srvrCsrName = configsMap.get(Configuration.SRVR_CSR_NAME.getKey());
        String srvrKeyName = configsMap.get(Configuration.SRVR_KEY_NAME.getKey());
        String kstrName = configsMap.get(Configuration.KSTR_NAME.getKey());
        String srvrCrtPass = configsMap.get(Configuration.SRVR_CRT_PASS.getKey());
        String srvrCrtPassFile = configsMap.get(Configuration.SRVR_CRT_PASS_FILE.getKey());
        Object[] scriptArgs = new Object[]{srvrCrtPass, srvrKstrDir, srvrKeyName, srvrCrtName, kstrName, srvrCsrName};
        String command = MessageFormat.format(GEN_SRVR_KEY, scriptArgs);
        this.runCommand(command);
        command = MessageFormat.format(GEN_SRVR_REQ, scriptArgs);
        this.runCommand(command);
        command = MessageFormat.format(SIGN_SRVR_CRT, scriptArgs);
        this.runCommand(command);
        command = MessageFormat.format(EXPRT_KSTR, scriptArgs);
        this.runCommand(command);
        command = String.format(SET_PERMISSIONS, srvrKstrDir);
        this.runCommand(command);
        command = String.format(SET_SERVER_PASS_FILE_PERMISSIONS, srvrKstrDir + File.separator + srvrCrtPassFile);
        this.runCommand(command);
    }

    public String getCACertificateChainContent() {
        String serverCertName;
        File certFile;
        String serverCertChainName;
        String serverCertDir = this.configs.getProperty(Configuration.SRVR_KSTR_DIR);
        File certChainFile = new File(serverCertDir, serverCertChainName = this.configs.getProperty(Configuration.SRVR_CRT_CHAIN_NAME));
        if (certChainFile.exists()) {
            try {
                return new String(Files.readAllBytes(certChainFile.toPath()));
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
        if ((certFile = new File(serverCertDir, serverCertName = this.configs.getProperty(Configuration.SRVR_CRT_NAME))).canRead()) {
            try {
                return new String(Files.readAllBytes(certFile.toPath()));
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
        return null;
    }

    public synchronized SignCertResponse signAgentCrt(String agentHostname, String agentCrtReqContent, String passphraseAgent) {
        SignCertResponse response = new SignCertResponse();
        LOG.info("Signing agent certificate");
        agentHostname = StringUtils.trim((String)agentHostname);
        if (StringUtils.isEmpty((String)agentHostname)) {
            LOG.warn("The agent hostname is missing");
            response.setResult("ERROR");
            response.setMessage("The agent hostname is missing");
            return response;
        }
        if (this.configs.validateAgentHostnames()) {
            LOG.info("Validating agent hostname: {}", (Object)agentHostname);
            if (!HostUtils.isValidHostname(agentHostname)) {
                LOG.warn("The agent hostname is not a valid hostname");
                response.setResult("ERROR");
                response.setMessage("The agent hostname is not a valid hostname");
                return response;
            }
        } else {
            LOG.info("Skipping validation of agent hostname: {}", (Object)agentHostname);
        }
        LOG.info("Verifying passphrase");
        String passphraseSrvr = this.configs.getConfigsMap().get(Configuration.PASSPHRASE.getKey()).trim();
        if (!passphraseSrvr.equals(passphraseAgent.trim())) {
            LOG.warn("Incorrect passphrase from the agent");
            response.setResult("ERROR");
            response.setMessage("Incorrect passphrase from the agent");
            return response;
        }
        Map<String, String> configsMap = this.configs.getConfigsMap();
        String srvrKstrDir = configsMap.get(Configuration.SRVR_KSTR_DIR.getKey());
        String srvrCrtPass = configsMap.get(Configuration.SRVR_CRT_PASS.getKey());
        String srvrCrtName = configsMap.get(Configuration.SRVR_CRT_NAME.getKey());
        String srvrKeyName = configsMap.get(Configuration.SRVR_KEY_NAME.getKey());
        String agentCrtReqName = agentHostname + ".csr";
        String agentCrtName = agentHostname + ".crt";
        Object[] scriptArgs = new Object[]{srvrKstrDir, agentCrtReqName, agentCrtName, srvrCrtPass, srvrKeyName, srvrCrtName};
        File agentCrtFile = new File(srvrKstrDir + File.separator + agentCrtName);
        if (agentCrtFile.exists()) {
            LOG.info("Revoking of " + agentHostname + " certificate.");
            String command = MessageFormat.format(REVOKE_AGENT_CRT, scriptArgs);
            int commandExitCode = this.runCommand(command);
            if (commandExitCode != 0) {
                response.setResult("ERROR");
                response.setMessage(ShellCommandUtil.getOpenSslCommandResult(command, commandExitCode));
                return response;
            }
        }
        File agentCrtReqFile = new File(srvrKstrDir + File.separator + agentCrtReqName);
        try {
            FileUtils.writeStringToFile((File)agentCrtReqFile, (String)agentCrtReqContent, (Charset)Charset.defaultCharset());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String command = MessageFormat.format(SIGN_AGENT_CRT, scriptArgs);
        LOG.debug(ShellCommandUtil.hideOpenSslPassword(command));
        int commandExitCode = this.runCommand(command);
        if (commandExitCode != 0) {
            response.setResult("ERROR");
            response.setMessage(ShellCommandUtil.getOpenSslCommandResult(command, commandExitCode));
            return response;
        }
        String agentCrtContent = "";
        try {
            agentCrtContent = FileUtils.readFileToString((File)agentCrtFile, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error reading signed agent certificate");
            response.setResult("ERROR");
            response.setMessage("Error reading signed agent certificate");
            return response;
        }
        response.setResult("OK");
        response.setSignedCa(agentCrtContent);
        return response;
    }
}

