/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security;

import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.AbstractSecurityHeaderFilter;
import jakarta.servlet.ServletRequest;

@Singleton
public class AmbariViewsSecurityHeaderFilter
extends AbstractSecurityHeaderFilter {
    @Override
    protected boolean checkPrerequisites(ServletRequest servletRequest) {
        servletRequest.setAttribute("deny.header.overrides.flag", (Object)"true");
        return true;
    }

    @Override
    protected void processConfig(Configuration configuration) {
        this.setSslEnabled(configuration.getApiSSLAuthentication());
        this.setStrictTransportSecurity(configuration.getViewsStrictTransportSecurityHTTPResponseHeader());
        this.setxFrameOptionsHeader(configuration.getViewsXFrameOptionsHTTPResponseHeader());
        this.setxXSSProtectionHeader(configuration.getViewsXXSSProtectionHTTPResponseHeader());
        this.setContentSecurityPolicyHeader(configuration.getViewsContentSecurityPolicyHTTPResponseHeader());
        this.setXContentTypeHeader(configuration.getViewsXContentTypeHTTPResponseHeader());
        this.setCacheControlHeader(configuration.getViewsCacheControlHTTPResponseHeader());
        this.setPragmaHeader(configuration.getViewsPragmaHTTPResponseHeader());
        this.setCharset(configuration.getViewsCharsetHTTPResponseHeader());
    }
}

