/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security;

import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.AbstractSecurityHeaderFilter;
import jakarta.servlet.ServletRequest;

@Singleton
public class AmbariServerSecurityHeaderFilter
extends AbstractSecurityHeaderFilter {
    @Override
    protected boolean checkPrerequisites(ServletRequest servletRequest) {
        boolean retVal = false;
        if (null == servletRequest.getAttribute("deny.header.overrides.flag")) {
            retVal = true;
        } else {
            servletRequest.removeAttribute("deny.header.overrides.flag");
        }
        return retVal;
    }

    @Override
    protected void processConfig(Configuration configuration) {
        this.setSslEnabled(configuration.getApiSSLAuthentication());
        this.setStrictTransportSecurity(configuration.getStrictTransportSecurityHTTPResponseHeader());
        this.setxFrameOptionsHeader(configuration.getXFrameOptionsHTTPResponseHeader());
        this.setxXSSProtectionHeader(configuration.getXXSSProtectionHTTPResponseHeader());
        this.setContentSecurityPolicyHeader(configuration.getContentSecurityPolicyHTTPResponseHeader());
        this.setXContentTypeHeader(configuration.getXContentTypeHTTPResponseHeader());
        this.setCacheControlHeader(configuration.getCacheControlHTTPResponseHeader());
        this.setPragmaHeader(configuration.getPragmaHTTPResponseHeader());
        this.setCharset(configuration.getCharsetHTTPResponseHeader());
    }
}

