/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security;

import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.authentication.kerberos.AmbariKerberosAuthenticationProperties;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class AmbariEntryPoint
implements AuthenticationEntryPoint {
    private final boolean kerberosAuthenticationEnabled;

    public AmbariEntryPoint(Configuration configuration) {
        AmbariKerberosAuthenticationProperties kerberosAuthenticationProperties = configuration == null ? null : configuration.getKerberosAuthenticationProperties();
        this.kerberosAuthenticationEnabled = kerberosAuthenticationProperties != null && kerberosAuthenticationProperties.isKerberosAuthenticationEnabled();
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (this.kerberosAuthenticationEnabled) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401, "Authentication requested");
        } else {
            response.sendError(403, authException.getMessage());
        }
    }
}

