/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security;

import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.Configuration;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityHeaderFilter
implements Filter {
    protected static final String STRICT_TRANSPORT_HEADER = "Strict-Transport-Security";
    protected static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    protected static final String X_XSS_PROTECTION_HEADER = "X-XSS-Protection";
    protected static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    protected static final String X_CONTENT_TYPE_HEADER = "X-Content-Type-Options";
    protected static final String CACHE_CONTROL_HEADER = "Cache-Control";
    protected static final String PRAGMA_HEADER = "Pragma";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSecurityHeaderFilter.class);
    protected static final String DENY_HEADER_OVERRIDES_FLAG = "deny.header.overrides.flag";
    @Inject
    private Configuration configuration;
    private boolean sslEnabled = true;
    private String strictTransportSecurity = Configuration.HTTP_STRICT_TRANSPORT_HEADER_VALUE.getDefaultValue();
    private String xFrameOptionsHeader = Configuration.HTTP_X_FRAME_OPTIONS_HEADER_VALUE.getDefaultValue();
    private String xXSSProtectionHeader = Configuration.HTTP_X_XSS_PROTECTION_HEADER_VALUE.getDefaultValue();
    private String contentSecurityPolicyHeader = Configuration.HTTP_CONTENT_SECURITY_POLICY_HEADER_VALUE.getDefaultValue();
    private String xContentTypeHeader = Configuration.HTTP_X_CONTENT_TYPE_HEADER_VALUE.getDefaultValue();
    private String cacheControlHeader = Configuration.HTTP_CACHE_CONTROL_HEADER_VALUE.getDefaultValue();
    private String pragmaHeader = Configuration.HTTP_PRAGMA_HEADER_VALUE.getDefaultValue();
    private String charset = Configuration.HTTP_CHARSET.getDefaultValue();

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.debug("Initializing {}", (Object)this.getClass().getName());
        if (this.configuration == null) {
            LOG.warn("The Ambari configuration object is not available, all default options will be assumed.");
        } else {
            this.processConfig(this.configuration);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.checkPrerequisites(servletRequest)) {
            this.doFilterInternal(servletRequest, servletResponse);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    protected abstract boolean checkPrerequisites(ServletRequest var1);

    public void destroy() {
        LOG.debug("Destroying {}", (Object)this.getClass().getName());
    }

    protected abstract void processConfig(Configuration var1);

    protected void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    protected void setStrictTransportSecurity(String strictTransportSecurity) {
        this.strictTransportSecurity = strictTransportSecurity;
    }

    protected void setxFrameOptionsHeader(String xFrameOptionsHeader) {
        this.xFrameOptionsHeader = xFrameOptionsHeader;
    }

    protected void setxXSSProtectionHeader(String xXSSProtectionHeader) {
        this.xXSSProtectionHeader = xXSSProtectionHeader;
    }

    protected void setContentSecurityPolicyHeader(String contentSecurityPolicyHeader) {
        this.contentSecurityPolicyHeader = contentSecurityPolicyHeader;
    }

    protected void setXContentTypeHeader(String xContentTypeHeader) {
        this.xContentTypeHeader = xContentTypeHeader;
    }

    protected void setCacheControlHeader(String cacheControlHeader) {
        this.cacheControlHeader = cacheControlHeader;
    }

    protected void setPragmaHeader(String pragmaHeader) {
        this.pragmaHeader = pragmaHeader;
    }

    protected void setCharset(String charset) {
        this.charset = charset;
    }

    private void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse) {
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            if (this.sslEnabled && !StringUtils.isEmpty((String)this.strictTransportSecurity)) {
                httpServletResponse.setHeader(STRICT_TRANSPORT_HEADER, this.strictTransportSecurity);
            }
            if (!StringUtils.isEmpty((String)this.xFrameOptionsHeader)) {
                httpServletResponse.setHeader(X_FRAME_OPTIONS_HEADER, this.xFrameOptionsHeader);
            }
            if (!StringUtils.isEmpty((String)this.xXSSProtectionHeader)) {
                httpServletResponse.setHeader(X_XSS_PROTECTION_HEADER, this.xXSSProtectionHeader);
            }
            if (!StringUtils.isEmpty((String)this.contentSecurityPolicyHeader)) {
                httpServletResponse.setHeader(CONTENT_SECURITY_POLICY_HEADER, this.contentSecurityPolicyHeader);
            }
            if (!StringUtils.isEmpty((String)this.xContentTypeHeader)) {
                httpServletResponse.setHeader(X_CONTENT_TYPE_HEADER, this.xContentTypeHeader);
            }
            if (!StringUtils.isEmpty((String)this.cacheControlHeader)) {
                httpServletResponse.setHeader(CACHE_CONTROL_HEADER, this.cacheControlHeader);
            }
            if (!StringUtils.isEmpty((String)this.pragmaHeader)) {
                httpServletResponse.setHeader(PRAGMA_HEADER, this.pragmaHeader);
            }
            if (!StringUtils.isEmpty((String)this.charset)) {
                httpServletResponse.setCharacterEncoding(this.charset);
            }
        }
    }
}

