/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.scheduler;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.scheduler.ExecutionScheduler;
import id.onyx.obdp.server.state.scheduler.GuiceJobFactory;
import java.util.List;
import java.util.Properties;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutionSchedulerImpl
implements ExecutionScheduler {
    @Inject
    private Configuration configuration;
    @Inject
    GuiceJobFactory guiceJobFactory;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionSchedulerImpl.class);
    protected static final String DEFAULT_SCHEDULER_NAME = "ExecutionScheduler";
    protected Scheduler scheduler;
    protected static volatile boolean isInitialized = false;

    @Inject
    public ExecutionSchedulerImpl(Injector injector) {
        injector.injectMembers((Object)this);
    }

    protected ExecutionSchedulerImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    protected synchronized void initializeScheduler() {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Properties properties = this.getQuartzSchedulerProperties();
        try {
            sf.initialize(properties);
        }
        catch (SchedulerException e) {
            LOG.warn("Failed to initialize Request Execution Scheduler properties !");
            LOG.debug("Scheduler properties: \n{}", (Object)properties);
            e.printStackTrace();
            return;
        }
        try {
            this.scheduler = sf.getScheduler();
            this.scheduler.setJobFactory((JobFactory)this.guiceJobFactory);
            isInitialized = true;
        }
        catch (SchedulerException e) {
            LOG.warn("Failed to create Request Execution scheduler !");
            e.printStackTrace();
        }
    }

    protected Properties getQuartzSchedulerProperties() {
        Properties properties = new Properties();
        properties.setProperty("org.quartz.scheduler.instanceName", DEFAULT_SCHEDULER_NAME);
        properties.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        properties.setProperty("org.quartz.threadPool.threadCount", this.configuration.getExecutionSchedulerThreads());
        properties.setProperty("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
        properties.setProperty("org.quartz.jobStore.isClustered", this.configuration.isExecutionSchedulerClusterd());
        String[] subProps = this.getQuartzDbDelegateClassAndValidationQuery();
        properties.setProperty("org.quartz.jobStore.driverDelegateClass", subProps[0]);
        properties.setProperty("org.quartz.jobStore.useProperties", "false");
        properties.setProperty("org.quartz.jobStore.dataSource", "myDS");
        properties.setProperty("org.quartz.dataSource.myDS.driver", this.configuration.getDatabaseDriver());
        properties.setProperty("org.quartz.dataSource.myDS.URL", this.configuration.getDatabaseUrl());
        properties.setProperty("org.quartz.dataSource.myDS.user", this.configuration.getDatabaseUser());
        properties.setProperty("org.quartz.dataSource.myDS.password", this.configuration.getDatabasePassword());
        properties.setProperty("org.quartz.dataSource.myDS.maxConnections", this.configuration.getExecutionSchedulerConnections());
        properties.setProperty("org.quartz.dataSource.myDS.maxCachedStatementsPerConnection", this.configuration.getExecutionSchedulerMaxStatementsPerConnection());
        properties.setProperty("org.quartz.dataSource.myDS.validationQuery", subProps[1]);
        properties.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
        LOG.debug("Using quartz properties: {}", (Object)properties);
        return properties;
    }

    protected synchronized boolean isInitialized() {
        return isInitialized;
    }

    protected String[] getQuartzDbDelegateClassAndValidationQuery() {
        String dbDelegate = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        String dbValidate = "select 0";
        Configuration.DatabaseType databaseType = this.configuration.getDatabaseType();
        if (databaseType == Configuration.DatabaseType.POSTGRES) {
            dbDelegate = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
        } else if (databaseType == Configuration.DatabaseType.ORACLE) {
            dbDelegate = "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
            dbValidate = "select 0 from dual";
        }
        return new String[]{dbDelegate, dbValidate};
    }

    @Override
    public synchronized void startScheduler(Integer delay) throws OBDPException {
        try {
            if (!isInitialized) {
                this.initializeScheduler();
                isInitialized = true;
            }
        }
        catch (Exception e) {
            String msg = "Unable to initialize Request Execution scheduler !";
            LOG.warn(msg);
            e.printStackTrace();
            throw new OBDPException(msg);
        }
        try {
            if (!this.scheduler.isStarted()) {
                if (delay != null) {
                    this.scheduler.startDelayed(delay.intValue());
                } else {
                    this.scheduler.start();
                }
            } else {
                LOG.info("Scheduler " + this.scheduler.getSchedulerInstanceId() + " already started. Skipping start.");
            }
        }
        catch (SchedulerException e) {
            LOG.error("Failed to start scheduler", (Throwable)e);
            throw new OBDPException(e.getMessage());
        }
    }

    @Override
    public synchronized void stopScheduler() throws OBDPException {
        if (this.scheduler == null) {
            throw new OBDPException("Scheduler not instantiated !");
        }
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            LOG.error("Failed to stop scheduler", (Throwable)e);
            throw new OBDPException(e.getMessage());
        }
    }

    @Override
    public void scheduleJob(Trigger trigger) throws SchedulerException {
        this.scheduler.scheduleJob(trigger);
    }

    @Override
    public void addJob(JobDetail jobDetail) throws SchedulerException {
        this.scheduler.addJob(jobDetail, true);
    }

    @Override
    public void deleteJob(JobKey jobKey) throws SchedulerException {
        this.scheduler.deleteJob(jobKey);
    }

    @Override
    public JobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getJobDetail(jobKey);
    }

    @Override
    public List<? extends Trigger> getTriggersForJob(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getTriggersOfJob(jobKey);
    }

    @Override
    public boolean isSchedulerStarted() throws SchedulerException {
        return this.scheduler.isStarted();
    }
}

