/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.scheduler;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.scheduler.ExecutionScheduler;
import id.onyx.obdp.server.security.authorization.internal.InternalTokenClientFilter;
import id.onyx.obdp.server.security.authorization.internal.InternalTokenStorage;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.scheduler.Batch;
import id.onyx.obdp.server.state.scheduler.BatchRequest;
import id.onyx.obdp.server.state.scheduler.BatchRequestJob;
import id.onyx.obdp.server.state.scheduler.BatchRequestResponse;
import id.onyx.obdp.server.state.scheduler.BatchSettings;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import id.onyx.obdp.server.state.scheduler.Schedule;
import id.onyx.obdp.server.utils.DateUtils;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutionScheduleManager {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionScheduleManager.class);
    private final InternalTokenStorage tokenStorage;
    private ActionDBAccessor actionDBAccessor;
    private final Gson gson;
    private final Clusters clusters;
    ExecutionScheduler executionScheduler;
    Configuration configuration;
    private volatile boolean schedulerAvailable = false;
    protected static final String BATCH_REQUEST_JOB_PREFIX = "BatchRequestJob";
    protected static final String REQUEST_EXECUTION_TRIGGER_PREFIX = "RequestExecution";
    protected static final String DEFAULT_API_PATH = "api/v1";
    public static final String USER_ID_HEADER = "X-Authenticated-User-ID";
    protected Client ambariClient;
    protected WebTarget ambariWebResource;
    protected static final String REQUESTS_STATUS_KEY = "request_status";
    protected static final String REQUESTS_ID_KEY = "id";
    protected static final String REQUESTS_FAILED_TASKS_KEY = "failed_task_count";
    protected static final String REQUESTS_ABORTED_TASKS_KEY = "aborted_task_count";
    protected static final String REQUESTS_TIMEDOUT_TASKS_KEY = "timed_out_task_count";
    protected static final String REQUESTS_TOTAL_TASKS_KEY = "task_count";
    protected static final Pattern CONTAINS_API_VERSION_PATTERN = Pattern.compile("^/?api/v1.*");

    @Inject
    public ExecutionScheduleManager(Configuration configuration, ExecutionScheduler executionScheduler, InternalTokenStorage tokenStorage, Clusters clusters, ActionDBAccessor actionDBAccessor, Gson gson) {
        this.configuration = configuration;
        this.executionScheduler = executionScheduler;
        this.tokenStorage = tokenStorage;
        this.clusters = clusters;
        this.actionDBAccessor = actionDBAccessor;
        this.gson = gson;
        try {
            this.buildApiClient();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected void buildApiClient() throws NoSuchAlgorithmException, KeyManagementException {
        Client client;
        String url;
        if (this.configuration.getApiSSLAuthentication()) {
            String pattern = "https://localhost:%s/";
            url = String.format(pattern, this.configuration.getClientSSLApiPort());
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            ClientConfig config = new ClientConfig();
            client = ClientBuilder.newBuilder().sslContext(sc).withConfig((jakarta.ws.rs.core.Configuration)config).build();
        } else {
            client = ClientBuilder.newBuilder().build();
            String pattern = "http://localhost:%s/";
            url = String.format(pattern, this.configuration.getClientApiPort());
        }
        this.ambariClient = client;
        this.ambariWebResource = client.target(url);
        CsrfProtectionFilter csrfFilter = new CsrfProtectionFilter("RequestSchedule");
        InternalTokenClientFilter tokenFilter = new InternalTokenClientFilter(this.tokenStorage);
        this.ambariWebResource.register((Object)csrfFilter);
        this.ambariWebResource.register((Object)tokenFilter);
    }

    public void start() {
        LOG.info("Starting scheduler");
        try {
            this.executionScheduler.startScheduler(this.configuration.getExecutionSchedulerStartDelay());
            this.schedulerAvailable = true;
        }
        catch (OBDPException e) {
            LOG.warn("Unable to start scheduler. No recurring tasks will be scheduled.");
        }
    }

    public void stop() {
        LOG.info("Stopping scheduler");
        this.schedulerAvailable = false;
        try {
            this.executionScheduler.stopScheduler();
        }
        catch (OBDPException e) {
            LOG.warn("Unable to stop scheduler. No new recurring tasks will be scheduled.");
        }
    }

    public boolean isSchedulerAvailable() {
        return this.schedulerAvailable;
    }

    public void scheduleJob(Trigger trigger) {
        LOG.debug("Scheduling job: {}", (Object)trigger.getJobKey());
        if (this.isSchedulerAvailable()) {
            try {
                this.executionScheduler.scheduleJob(trigger);
            }
            catch (SchedulerException e) {
                LOG.error("Unable to add trigger for execution job: " + trigger.getJobKey(), (Throwable)e);
            }
        } else {
            LOG.error("Scheduler unavailable, cannot schedule jobs.");
        }
    }

    public boolean continueOnMisfire(JobExecutionContext jobExecutionContext) {
        if (jobExecutionContext != null) {
            Date scheduledTime = jobExecutionContext.getScheduledFireTime();
            Long diff = DateUtils.getDateDifferenceInMinutes(scheduledTime);
            return diff < this.configuration.getExecutionSchedulerMisfireToleration();
        }
        return true;
    }

    private long getFirstJobOrderId(RequestExecution requestExecution) throws OBDPException {
        List<BatchRequest> batchRequests;
        Long firstBatchOrderId = null;
        Batch batch = requestExecution.getBatch();
        if (batch != null && (batchRequests = batch.getBatchRequests()) != null) {
            Collections.sort(batchRequests);
            ListIterator<BatchRequest> iterator = batchRequests.listIterator();
            firstBatchOrderId = iterator.next().getOrderId();
        }
        if (firstBatchOrderId == null) {
            throw new OBDPException("Can't schedule RequestExecution with no batches");
        }
        return firstBatchOrderId;
    }

    public void scheduleAllBatches(RequestExecution requestExecution) throws OBDPException {
        Long firstBatchOrderId = this.getFirstJobOrderId(requestExecution);
        this.scheduleBatch(requestExecution, firstBatchOrderId);
    }

    public void scheduleBatch(RequestExecution requestExecution, long startingBatchOrderId) throws OBDPException {
        if (!this.isSchedulerAvailable()) {
            throw new OBDPException("Scheduler unavailable.");
        }
        try {
            if (!this.executionScheduler.isSchedulerStarted()) {
                this.executionScheduler.startScheduler(null);
            }
        }
        catch (SchedulerException e) {
            LOG.error("Unable to determine scheduler state.", (Throwable)e);
            throw new OBDPException("Scheduler unavailable.");
        }
        LOG.debug("Scheduling jobs starting from " + startingBatchOrderId);
        JobDetail firstJobDetail = this.persistBatch(requestExecution, startingBatchOrderId);
        if (firstJobDetail == null) {
            throw new OBDPException("Unable to schedule jobs. firstJobDetail = " + firstJobDetail);
        }
        Integer failedCount = this.countFailedTasksBeforeStartingBatch(requestExecution, startingBatchOrderId);
        Schedule schedule = requestExecution.getSchedule();
        if (schedule != null) {
            String triggerExpression = schedule.getScheduleExpression();
            Date startDate = null;
            Date endDate = null;
            try {
                String startTime = schedule.getStartTime();
                String endTime = schedule.getEndTime();
                startDate = startTime != null && !startTime.isEmpty() ? DateUtils.convertToDate(startTime) : new Date();
                endDate = endTime != null && !endTime.isEmpty() ? DateUtils.convertToDate(endTime) : null;
            }
            catch (ParseException e) {
                LOG.error("Unable to parse startTime / endTime.", (Throwable)e);
            }
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("RequestExecution-" + requestExecution.getId(), "LinearExecutionTriggers").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)triggerExpression).withMisfireHandlingInstructionFireAndProceed()).forJob(firstJobDetail).usingJobData("BatchRequestJob.FailedTaskCount", failedCount).startAt(startDate).endAt(endDate).build();
            try {
                this.executionScheduler.scheduleJob(trigger);
                LOG.debug("Scheduled trigger next fire time: {}", (Object)trigger.getNextFireTime());
            }
            catch (SchedulerException e) {
                LOG.error("Unable to schedule request execution.", (Throwable)e);
                throw new OBDPException(e.getMessage());
            }
        }
        Trigger trigger = TriggerBuilder.newTrigger().forJob(firstJobDetail).withIdentity("RequestExecution-" + requestExecution.getId(), "LinearExecutionTriggers").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).usingJobData("BatchRequestJob.FailedTaskCount", failedCount).startNow().build();
        try {
            this.executionScheduler.scheduleJob(trigger);
            LOG.debug("Scheduled trigger next fire time: {}", (Object)trigger.getNextFireTime());
        }
        catch (SchedulerException e) {
            LOG.error("Unable to schedule request execution.", (Throwable)e);
            throw new OBDPException(e.getMessage());
        }
    }

    private Integer countFailedTasksBeforeStartingBatch(RequestExecution requestExecution, long startingBatchOrderId) throws OBDPException {
        List<BatchRequest> batchRequests;
        int result = 0;
        Batch batch = requestExecution.getBatch();
        if (batch != null && (batchRequests = batch.getBatchRequests()) != null) {
            Collections.sort(batchRequests);
            for (BatchRequest batchRequest : batchRequests) {
                BatchRequestResponse batchRequestResponse;
                if (batchRequest.getOrderId() >= startingBatchOrderId) break;
                if (batchRequest.getRequestId() == null || (batchRequestResponse = this.getBatchRequestResponse(batchRequest.getRequestId(), requestExecution.getClusterName())) == null) continue;
                result += batchRequestResponse.getFailedTaskCount() + batchRequestResponse.getAbortedTaskCount() + batchRequestResponse.getTimedOutTaskCount();
            }
        }
        return result;
    }

    private JobDetail persistBatch(RequestExecution requestExecution, long startingBatchOrderId) throws OBDPException {
        List<BatchRequest> batchRequests;
        Batch batch = requestExecution.getBatch();
        JobDetail jobDetail = null;
        if (batch != null && (batchRequests = batch.getBatchRequests()) != null) {
            Collections.sort(batchRequests);
            ListIterator<BatchRequest> iterator = batchRequests.listIterator(batchRequests.size());
            String nextJobName = null;
            long nextBatchOrderId = 0x3FFFFFFFL;
            while (nextBatchOrderId != startingBatchOrderId && iterator.hasPrevious()) {
                BatchRequest batchRequest = iterator.previous();
                String jobName = this.getJobName(requestExecution.getId(), batchRequest.getOrderId());
                Integer separationSeconds = requestExecution.getBatch().getBatchSettings().getBatchSeparationInSeconds();
                jobDetail = JobBuilder.newJob(BatchRequestJob.class).withIdentity(jobName, "LinearExecutionJobs").usingJobData("ExecutionJob.Name", nextJobName).usingJobData("ExecutionJob.Group", "LinearExecutionJobs").usingJobData("BatchRequestJob.ExecutionId", requestExecution.getId()).usingJobData("BatchRequestJob.BatchId", batchRequest.getOrderId()).usingJobData("BatchRequestJob.ClusterName", requestExecution.getClusterName()).usingJobData("ExecutionJob.SeparationMinutes", Integer.valueOf(separationSeconds != null ? separationSeconds : 0)).storeDurably().build();
                try {
                    this.executionScheduler.addJob(jobDetail);
                }
                catch (SchedulerException e) {
                    LOG.error("Failed to add job detail. " + batchRequest, (Throwable)e);
                }
                nextJobName = jobName;
                nextBatchOrderId = batchRequest.getOrderId();
            }
        }
        return jobDetail;
    }

    protected String getJobName(Long executionId, Long orderId) {
        return "BatchRequestJob-" + executionId + "-" + orderId;
    }

    public void updateBatchSchedule(RequestExecution requestExecution) throws OBDPException {
        BatchRequest activeBatch = this.calculateActiveBatch(requestExecution);
        if (activeBatch == null) {
            LOG.warn("Ignoring RequestExecution status update since all batches has been executed");
            return;
        }
        if (requestExecution.getStatus().equals(RequestExecution.Status.SCHEDULED.name())) {
            this.scheduleBatch(requestExecution, activeBatch.getOrderId());
        } else if (requestExecution.getStatus().equals(RequestExecution.Status.PAUSED.name()) || requestExecution.getStatus().equals(RequestExecution.Status.ABORTED.name())) {
            LOG.info("Request execution status changed to " + requestExecution.getStatus() + " for request schedule " + requestExecution.getId() + ". Deleting related jobs.");
            this.deleteJobs(requestExecution, activeBatch.getOrderId());
            Collection<Long> requestIDsToAbort = requestExecution.getBatchRequestRequestsIDs(activeBatch.getOrderId());
            for (Long requestId : requestIDsToAbort) {
                if (requestId == null) continue;
                this.abortRequestById(requestExecution, requestId);
            }
        }
    }

    private BatchRequest calculateActiveBatch(RequestExecution requestExecution) {
        List<BatchRequest> batchRequests;
        BatchRequest result = null;
        Batch batch = requestExecution.getBatch();
        if (batch != null && (batchRequests = batch.getBatchRequests()) != null) {
            Collections.sort(batchRequests);
            ListIterator<BatchRequest> iterator = batchRequests.listIterator();
            do {
                result = iterator.next();
            } while (iterator.hasNext() && result.getStatus() != null && HostRoleStatus.getCompletedStates().contains((Object)HostRoleStatus.valueOf(result.getStatus())) && !HostRoleStatus.ABORTED.name().equals(result.getStatus()));
        }
        if (result != null && result.getStatus() != null && HostRoleStatus.getCompletedStates().contains((Object)HostRoleStatus.valueOf(result.getStatus())) && !HostRoleStatus.ABORTED.name().equals(result.getStatus())) {
            return null;
        }
        return result;
    }

    public void validateSchedule(Schedule schedule) throws OBDPException {
        Date startDate = null;
        Date endDate = null;
        if (!schedule.isEmpty()) {
            String cronExpression;
            if (schedule.getStartTime() != null && !schedule.getStartTime().isEmpty()) {
                try {
                    startDate = DateUtils.convertToDate(schedule.getStartTime());
                }
                catch (ParseException pe) {
                    throw new OBDPException("Start time in invalid format. startTime = " + schedule.getStartTime() + ", Allowed format = yyyy-MM-dd'T'HH:mm:ssz");
                }
            }
            if (schedule.getEndTime() != null && !schedule.getEndTime().isEmpty()) {
                try {
                    endDate = DateUtils.convertToDate(schedule.getEndTime());
                }
                catch (ParseException pe) {
                    throw new OBDPException("End time in invalid format. endTime = " + schedule.getEndTime() + ", Allowed format = yyyy-MM-dd'T'HH:mm:ssz");
                }
            }
            if (endDate != null) {
                if (endDate.before(new Date())) {
                    throw new OBDPException("End date should be in the future. endDate = " + endDate);
                }
                if (startDate != null && endDate.before(startDate)) {
                    throw new OBDPException("End date cannot be before start date. startDate = " + startDate + ", endDate = " + endDate);
                }
            }
            if ((cronExpression = schedule.getScheduleExpression()) != null && !cronExpression.trim().isEmpty() && !CronExpression.isValidExpression((String)cronExpression)) {
                throw new OBDPException("Invalid non-empty cron expression provided. " + cronExpression);
            }
        }
    }

    public void deleteAllJobs(RequestExecution requestExecution) throws OBDPException {
        Long firstBatchOrderId = this.getFirstJobOrderId(requestExecution);
        this.deleteJobs(requestExecution, firstBatchOrderId);
    }

    public void deleteJobs(RequestExecution requestExecution, Long startingBatchOrderId) throws OBDPException {
        List<BatchRequest> batchRequests;
        if (!this.isSchedulerAvailable()) {
            throw new OBDPException("Scheduler unavailable.");
        }
        Batch batch = requestExecution.getBatch();
        if (batch != null && (batchRequests = batch.getBatchRequests()) != null) {
            Collections.sort(batchRequests);
            for (BatchRequest batchRequest : batchRequests) {
                if (batchRequest.getOrderId() < startingBatchOrderId) continue;
                String jobName = this.getJobName(requestExecution.getId(), batchRequest.getOrderId());
                LOG.debug("Deleting Job, jobName = {}", (Object)jobName);
                try {
                    this.executionScheduler.deleteJob(JobKey.jobKey((String)jobName, (String)"LinearExecutionJobs"));
                }
                catch (SchedulerException e) {
                    LOG.warn("Unable to delete job, " + jobName, (Throwable)e);
                    throw new OBDPException(e.getMessage());
                }
            }
        }
    }

    public Long executeBatchRequest(long executionId, long batchId, String clusterName) throws OBDPException {
        String type = null;
        String uri = null;
        String body = null;
        try {
            RequestExecution requestExecution = this.clusters.getCluster(clusterName).getAllRequestExecutions().get(executionId);
            BatchRequest batchRequest = requestExecution.getBatchRequest(batchId);
            type = batchRequest.getType();
            uri = batchRequest.getUri();
            body = requestExecution.getRequestBody(batchId);
            BatchRequestResponse batchRequestResponse = this.performApiRequest(uri, body, type, requestExecution.getAuthenticatedUserId());
            this.updateBatchRequest(executionId, batchId, clusterName, batchRequestResponse, false);
            if (batchRequestResponse.getRequestId() != null) {
                this.actionDBAccessor.setSourceScheduleForRequest(batchRequestResponse.getRequestId(), executionId);
            }
            batchRequest.setRequestId(batchRequestResponse.getRequestId());
            return batchRequestResponse.getRequestId();
        }
        catch (Exception e) {
            throw new OBDPException("Exception occurred while performing request", (Throwable)e);
        }
    }

    public BatchRequestResponse getBatchRequestResponse(Long requestId, String clusterName) throws OBDPException {
        StrBuilder sb = new StrBuilder();
        sb.append(DEFAULT_API_PATH).append("/clusters/").append(clusterName).append("/requests/").append((Object)requestId);
        return this.performApiGetRequest(sb.toString(), true);
    }

    protected RequestStatus abortRequestById(RequestExecution requestExecution, Long requestId) throws OBDPException {
        LOG.debug("Aborting request " + requestId);
        ResourceProvider provider = AbstractControllerResourceProvider.getResourceProvider(Resource.Type.Request);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("Requests/cluster_name", requestExecution.getClusterName());
        properties.put("Requests/abort_reason", "Request execution status changed to " + requestExecution.getStatus());
        properties.put("Requests/id", Long.toString(requestId));
        properties.put("Requests/request_status", HostRoleStatus.ABORTED.name());
        RequestImpl request = new RequestImpl(Collections.emptySet(), Collections.singleton(properties), Collections.emptyMap(), null);
        Predicate predicate = new PredicateBuilder().property("Requests/cluster_name").equals(requestExecution.getClusterName()).and().property("Requests/id").equals(Long.toString(requestId)).toPredicate();
        try {
            return provider.updateResources(request, predicate);
        }
        catch (Exception e) {
            throw new OBDPException("Error while aborting the request.", (Throwable)e);
        }
    }

    private BatchRequestResponse convertToBatchRequestResponse(Response clientResponse) {
        HashMap<String, String> httpResponseMap;
        BatchRequestResponse batchRequestResponse = new BatchRequestResponse();
        int retCode = clientResponse.getStatus();
        batchRequestResponse.setReturnCode(retCode);
        String responseString = (String)clientResponse.getEntity();
        LOG.debug("Processing API response: status={}, body={}", (Object)retCode, (Object)responseString);
        try {
            httpResponseMap = (HashMap<String, String>)this.gson.fromJson(responseString, Map.class);
            LOG.debug("Processing responce as JSON");
        }
        catch (JsonSyntaxException e) {
            LOG.debug("Response is not valid JSON object. Recording as is");
            httpResponseMap = new HashMap<String, String>();
            httpResponseMap.put("message", responseString);
        }
        if (retCode < 300) {
            if (httpResponseMap == null) {
                batchRequestResponse.setStatus(HostRoleStatus.COMPLETED.toString());
                return batchRequestResponse;
            }
            Map requestMap = null;
            Object requestMapObject = httpResponseMap.get("Requests");
            if (requestMapObject instanceof Map) {
                requestMap = (Map)requestMapObject;
            }
            if (requestMap != null) {
                batchRequestResponse.setRequestId(((Double)requestMap.get(REQUESTS_ID_KEY)).longValue());
                String status = null;
                if (requestMap.get(REQUESTS_STATUS_KEY) != null) {
                    status = requestMap.get(REQUESTS_STATUS_KEY).toString();
                }
                if (requestMap.get("status") != null) {
                    status = requestMap.get("status").toString();
                }
                if (requestMap.get(REQUESTS_ABORTED_TASKS_KEY) != null) {
                    batchRequestResponse.setAbortedTaskCount(((Double)requestMap.get(REQUESTS_ABORTED_TASKS_KEY)).intValue());
                }
                if (requestMap.get(REQUESTS_FAILED_TASKS_KEY) != null) {
                    batchRequestResponse.setFailedTaskCount(((Double)requestMap.get(REQUESTS_FAILED_TASKS_KEY)).intValue());
                }
                if (requestMap.get(REQUESTS_TIMEDOUT_TASKS_KEY) != null) {
                    batchRequestResponse.setTimedOutTaskCount(((Double)requestMap.get(REQUESTS_TIMEDOUT_TASKS_KEY)).intValue());
                }
                if (requestMap.get(REQUESTS_TOTAL_TASKS_KEY) != null) {
                    batchRequestResponse.setTotalTaskCount(((Double)requestMap.get(REQUESTS_TOTAL_TASKS_KEY)).intValue());
                }
                batchRequestResponse.setStatus(status);
            }
        } else {
            batchRequestResponse.setReturnMessage((String)httpResponseMap.get("message"));
            batchRequestResponse.setStatus(HostRoleStatus.FAILED.toString());
        }
        return batchRequestResponse;
    }

    public String getBatchRequestStatus(Long executionId, String clusterName) throws OBDPException {
        Cluster cluster = this.clusters.getCluster(clusterName);
        RequestExecution requestExecution = cluster.getAllRequestExecutions().get(executionId);
        if (requestExecution == null) {
            throw new OBDPException("Unable to find request schedule with id = " + executionId);
        }
        return requestExecution.getStatus();
    }

    public void updateBatchRequest(long executionId, long batchId, String clusterName, BatchRequestResponse batchRequestResponse, boolean statusOnly) throws OBDPException {
        Cluster cluster = this.clusters.getCluster(clusterName);
        RequestExecution requestExecution = cluster.getAllRequestExecutions().get(executionId);
        if (requestExecution == null) {
            throw new OBDPException("Unable to find request schedule with id = " + executionId);
        }
        requestExecution.updateBatchRequest(batchId, batchRequestResponse, statusOnly);
    }

    protected BatchRequestResponse performUriRequest(String url, String body, String method) {
        Response response;
        block6: {
            try {
                WebTarget target = ClientBuilder.newClient().target(url);
                Invocation.Builder invocationBuilder = target.request();
                if (method.equalsIgnoreCase("GET")) {
                    response = invocationBuilder.get();
                    break block6;
                }
                if (method.equalsIgnoreCase("POST")) {
                    response = invocationBuilder.post(Entity.entity((Object)body, (String)"application/json"));
                    break block6;
                }
                if (method.equalsIgnoreCase("PUT")) {
                    response = invocationBuilder.put(Entity.entity((Object)body, (String)"application/json"));
                    break block6;
                }
                if (method.equalsIgnoreCase("DELETE")) {
                    response = invocationBuilder.delete();
                    break block6;
                }
                throw new IllegalArgumentException("Invalid HTTP method: " + method);
            }
            catch (Exception e) {
                response = null;
            }
        }
        return this.convertToBatchRequestResponse(response);
    }

    protected BatchRequestResponse performApiGetRequest(String relativeUri, boolean queryAllFields) {
        Response response;
        WebTarget target = this.extendApiResource(this.ambariWebResource, relativeUri);
        if (queryAllFields) {
            target = target.queryParam("fields", new Object[]{"*"});
        }
        try {
            response = target.request().get();
        }
        catch (Exception e) {
            LOG.error("Exception occurred during API request to {}: {}", new Object[]{relativeUri, e.getMessage(), e});
            response = null;
        }
        return this.convertToBatchRequestResponse(response);
    }

    protected BatchRequestResponse performApiRequest(String relativeUri, String body, String method, Integer userId) {
        Response response;
        block6: {
            WebTarget target = this.extendApiResource(this.ambariWebResource, relativeUri);
            try {
                Invocation.Builder invocationBuilder = target.request().header(USER_ID_HEADER, (Object)userId);
                if (method.equalsIgnoreCase("GET")) {
                    response = invocationBuilder.get();
                    break block6;
                }
                if (method.equalsIgnoreCase("POST")) {
                    response = invocationBuilder.post(Entity.entity((Object)body, (String)"application/json"));
                    break block6;
                }
                if (method.equalsIgnoreCase("PUT")) {
                    response = invocationBuilder.put(Entity.entity((Object)body, (String)"application/json"));
                    break block6;
                }
                if (method.equalsIgnoreCase("DELETE")) {
                    response = invocationBuilder.delete();
                    break block6;
                }
                throw new IllegalArgumentException("Invalid HTTP method: " + method);
            }
            catch (Exception e) {
                LOG.error("Exception occurred during API request to {}: {}", new Object[]{relativeUri, e.getMessage(), e});
                response = null;
            }
        }
        return this.convertToBatchRequestResponse(response);
    }

    public boolean hasToleranceThresholdExceeded(Long executionId, String clusterName, Map<String, Integer> taskCounts) throws OBDPException {
        Cluster cluster = this.clusters.getCluster(clusterName);
        RequestExecution requestExecution = cluster.getAllRequestExecutions().get(executionId);
        if (requestExecution == null) {
            throw new OBDPException("Unable to find request schedule with id = " + executionId);
        }
        BatchSettings batchSettings = requestExecution.getBatch().getBatchSettings();
        boolean result = false;
        if (batchSettings != null) {
            if (batchSettings.getTaskFailureToleranceLimit() != null) {
                boolean bl = result = taskCounts.get("BatchRequestJob.FailedTaskCount") > batchSettings.getTaskFailureToleranceLimit();
            }
            if (batchSettings.getTaskFailureToleranceLimitPerBatch() != null) {
                result = result || taskCounts.get("BatchRequestJob.FailedTaskInCurrentBatchCount") > batchSettings.getTaskFailureToleranceLimitPerBatch();
            }
        }
        return result;
    }

    public void finalizeBatch(long executionId, String clusterName) throws OBDPException {
        List<BatchRequest> batchRequests;
        Cluster cluster = this.clusters.getCluster(clusterName);
        RequestExecution requestExecution = cluster.getAllRequestExecutions().get(executionId);
        if (requestExecution == null) {
            throw new OBDPException("Unable to find request schedule with id = " + executionId);
        }
        Batch batch = requestExecution.getBatch();
        BatchRequest firstBatchRequest = null;
        if (batch != null && (batchRequests = batch.getBatchRequests()) != null && batchRequests.size() > 0) {
            Collections.sort(batchRequests);
            firstBatchRequest = batchRequests.get(0);
        }
        boolean markCompleted = false;
        if (firstBatchRequest != null) {
            JobDetail jobDetail;
            String jobName = this.getJobName(executionId, firstBatchRequest.getOrderId());
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)"LinearExecutionJobs");
            try {
                jobDetail = this.executionScheduler.getJobDetail(jobKey);
            }
            catch (SchedulerException e) {
                LOG.warn("Unable to retrieve job details from scheduler. job: " + jobKey);
                e.printStackTrace();
                return;
            }
            if (jobDetail != null) {
                try {
                    List<? extends Trigger> triggers = this.executionScheduler.getTriggersForJob(jobKey);
                    if (triggers != null && triggers.size() > 0) {
                        if (triggers.size() > 1) {
                            throw new OBDPException("Too many triggers defined for job. job: " + jobKey);
                        }
                        Trigger trigger = triggers.get(0);
                        if (!trigger.mayFireAgain() || trigger.getFinalFireTime() != null && !DateUtils.isFutureTime(trigger.getFinalFireTime())) {
                            markCompleted = true;
                        }
                    } else {
                        markCompleted = true;
                    }
                }
                catch (SchedulerException e) {
                    LOG.warn("Unable to retrieve triggers for job: " + jobKey);
                    e.printStackTrace();
                    return;
                }
            }
        }
        if (markCompleted) {
            requestExecution.updateStatus(RequestExecution.Status.COMPLETED);
        }
    }

    protected WebTarget extendApiResource(WebTarget webTarget, String relativeUri) {
        WebTarget result = webTarget;
        if (StringUtils.isNotEmpty((String)relativeUri) && !CONTAINS_API_VERSION_PATTERN.matcher(relativeUri).matches()) {
            result = webTarget.path(DEFAULT_API_PATH);
        }
        return result.path(relativeUri);
    }

    public void pauseAfterBatchIfNeeded(long executionId, long batchId, String clusterName) throws OBDPException {
        BatchSettings batchSettings;
        Cluster cluster = this.clusters.getCluster(clusterName);
        RequestExecution requestExecution = cluster.getAllRequestExecutions().get(executionId);
        if (requestExecution == null) {
            throw new OBDPException("Unable to find request schedule with id = " + executionId);
        }
        Batch batch = requestExecution.getBatch();
        if (batch != null && (batchSettings = batch.getBatchSettings()) != null && RequestExecution.Status.SCHEDULED.name().equals(requestExecution.getStatus()) && this.getFirstJobOrderId(requestExecution) == batchId && batchSettings.isPauseAfterFirstBatch().booleanValue()) {
            LOG.info("Auto pausing the scheduled request after first batch. Scheduled request ID : " + executionId);
            requestExecution.updateStatus(RequestExecution.Status.PAUSED);
        }
    }
}

