/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.scheduler;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.scheduler.ExecutionJob;
import id.onyx.obdp.server.scheduler.ExecutionScheduleManager;
import id.onyx.obdp.server.state.scheduler.RequestExecution;
import java.util.Map;
import org.quartz.DateBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLinearExecutionJob
implements ExecutionJob {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLinearExecutionJob.class);
    protected ExecutionScheduleManager executionScheduleManager;

    public AbstractLinearExecutionJob(ExecutionScheduleManager executionScheduleManager) {
        this.executionScheduleManager = executionScheduleManager;
    }

    protected abstract void doWork(Map<String, Object> var1) throws OBDPException;

    protected abstract void finalizeExecution(Map<String, Object> var1) throws OBDPException;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobKey jobKey = context.getJobDetail().getKey();
        LOG.debug("Executing linear job: {}", (Object)jobKey);
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        if (!this.executionScheduleManager.continueOnMisfire(context)) {
            throw new JobExecutionException("Canceled execution based on misfire toleration threshold, job: " + jobKey + ", scheduleTime = " + context.getScheduledFireTime());
        }
        Map properties = jobDataMap.getWrappedMap();
        boolean finalize = false;
        try {
            this.doWork(properties);
        }
        catch (OBDPException e) {
            LOG.error("Exception caught on execution of job " + jobKey + ". Exiting linear chain...", (Throwable)e);
            finalize = true;
            throw new JobExecutionException((Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected exception caught on execution of job " + jobKey + ". Exiting linear chain...", (Throwable)e);
            finalize = true;
            throw e;
        }
        finally {
            if (finalize) {
                try {
                    this.finalizeExecution(properties);
                }
                catch (OBDPException e) {
                    LOG.warn("Unable to finalize execution for job: " + jobKey);
                }
            }
        }
        LOG.debug("Finished linear job: {}", (Object)jobKey);
        String nextJobName = jobDataMap.getString("ExecutionJob.Name");
        String nextJobGroup = jobDataMap.getString("ExecutionJob.Group");
        if (nextJobName == null || nextJobName.isEmpty()) {
            LOG.debug("End of linear job chain. Returning with success.");
            try {
                this.finalizeExecution(properties);
            }
            catch (OBDPException e) {
                LOG.warn("Unable to finalize execution for job: " + jobKey);
            }
            return;
        }
        try {
            this.executionScheduleManager.pauseAfterBatchIfNeeded(jobDataMap.getLong("BatchRequestJob.ExecutionId"), jobDataMap.getLong("BatchRequestJob.BatchId"), jobDataMap.getString("BatchRequestJob.ClusterName"));
        }
        catch (OBDPException e) {
            LOG.warn("Received exception while trying to auto pause the scheduled request execution :", (Throwable)e);
        }
        String status = null;
        try {
            status = this.executionScheduleManager.getBatchRequestStatus(jobDataMap.getLong("BatchRequestJob.ExecutionId"), jobDataMap.getString("BatchRequestJob.ClusterName"));
        }
        catch (OBDPException e) {
            LOG.warn("Unable to define the status of batch request : ", (Throwable)e);
        }
        if (RequestExecution.Status.ABORTED.name().equals(status) || RequestExecution.Status.PAUSED.name().equals(status)) {
            LOG.info("The linear job chain was paused or aborted, not triggering the next one");
            return;
        }
        int separationSeconds = jobDataMap.getIntValue("ExecutionJob.SeparationMinutes");
        Object failedCount = properties.get("BatchRequestJob.FailedTaskCount");
        Object totalCount = properties.get("BatchRequestJob.TotalTaskCount");
        Trigger trigger = TriggerBuilder.newTrigger().forJob(nextJobName, nextJobGroup).withIdentity("TriggerForJob-" + nextJobName, "LinearExecutionTriggers").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow()).startAt(DateBuilder.futureDate((int)separationSeconds, (DateBuilder.IntervalUnit)DateBuilder.IntervalUnit.SECOND)).usingJobData("BatchRequestJob.FailedTaskCount", Integer.valueOf(failedCount != null ? (Integer)failedCount : 0)).usingJobData("BatchRequestJob.TotalTaskCount", Integer.valueOf(totalCount != null ? (Integer)totalCount : 0)).build();
        this.executionScheduleManager.scheduleJob(trigger);
    }
}

