/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.resources.api.rest;

import com.google.inject.Inject;
import id.onyx.obdp.server.resources.ResourceManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class GetResource {
    private static final Logger LOG = LoggerFactory.getLogger(GetResource.class);
    private static ResourceManager resourceManager;

    @Inject
    public static void init(ResourceManager instance) {
        resourceManager = instance;
    }

    @GET
    @Path(value="{resourcePath:.*}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/octet-stream"})
    public Response getResource(@PathParam(value="resourcePath") String resourcePath, @Context HttpServletRequest req) {
        File resourceFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received a resource request from agent, resourcePath={}", (Object)resourcePath);
        }
        if (!(resourceFile = resourceManager.getResource(resourcePath)).exists()) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)resourceFile).build();
    }
}

