/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.resources;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManager.class);
    @Inject
    Configuration configs;

    public File getResource(String resourcePath) {
        String resDir = this.configs.getConfigsMap().get(Configuration.RESOURCES_DIR.getKey());
        String resourcePathIndep = resourcePath.replace("/", File.separator);
        File resourceFile = new File(resDir + File.separator + resourcePathIndep);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource requested from ResourceManager, resourceDir={}, resourcePath={}, fileExists={}", new Object[]{resDir, resourcePathIndep, resourceFile.exists()});
        }
        return resourceFile;
    }
}

