/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.proxy;

import com.google.gson.Gson;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ProxyService {
    public static final int URL_CONNECT_TIMEOUT = 20000;
    public static final int URL_READ_TIMEOUT = 15000;
    public static final int HTTP_ERROR_RANGE_START = Response.Status.BAD_REQUEST.getStatusCode();
    private static final String REQUEST_TYPE_GET = "GET";
    private static final String REQUEST_TYPE_POST = "POST";
    private static final String REQUEST_TYPE_PUT = "PUT";
    private static final String REQUEST_TYPE_DELETE = "DELETE";
    private static final String QUERY_PARAMETER_URL = "url=";
    private static final String AMBARI_PROXY_PREFIX = "AmbariProxy-";
    private static final String ERROR_PROCESSING_URL = "Error occurred during processing URL ";
    private static final String INVALID_PARAM_IN_URL = "Invalid query params found in URL ";
    private static final Logger LOG = LoggerFactory.getLogger(ProxyService.class);

    @GET
    public Response processGetRequestForwarding(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(REQUEST_TYPE_GET, ui, null, headers);
    }

    @POST
    @Consumes(value={"*/*", "text/plain", "text/xml", "application/x-www-form-urlencoded", "application/json"})
    public Response processPostRequestForwarding(InputStream body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(REQUEST_TYPE_POST, ui, body, headers);
    }

    @PUT
    @Consumes(value={"*/*", "text/plain", "text/xml", "application/x-www-form-urlencoded", "application/json"})
    public Response processPutRequestForwarding(InputStream body, @Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(REQUEST_TYPE_PUT, ui, body, headers);
    }

    @DELETE
    public Response processDeleteRequestForwarding(@Context HttpHeaders headers, @Context UriInfo ui) {
        return this.handleRequest(REQUEST_TYPE_DELETE, ui, null, headers);
    }

    private Response handleRequest(String requestType, UriInfo ui, InputStream body, HttpHeaders headers) {
        URLStreamProvider urlStreamProvider = new URLStreamProvider(20000, 15000, null, null, null);
        String query = ui.getRequestUri().getQuery();
        if (query != null && query.indexOf(QUERY_PARAMETER_URL) != -1) {
            String url = query.replaceFirst(QUERY_PARAMETER_URL, "");
            MultivaluedMap m = ui.getQueryParameters();
            if (m.containsKey((Object)"doAs")) {
                LOG.error(INVALID_PARAM_IN_URL + url);
                return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type("text/plain").entity((Object)INVALID_PARAM_IN_URL).build();
            }
            try {
                HttpURLConnection connection = urlStreamProvider.processURL(url, requestType, body, this.getHeaderParamsToForward(headers));
                int responseCode = connection.getResponseCode();
                InputStream resultInputStream = null;
                resultInputStream = responseCode >= HTTP_ERROR_RANGE_START ? connection.getErrorStream() : connection.getInputStream();
                String contentType = connection.getContentType();
                Response.ResponseBuilder rb = Response.status((int)responseCode);
                if (contentType.indexOf("application/json") != -1) {
                    rb.entity(new Gson().fromJson((Reader)new InputStreamReader(resultInputStream), Map.class));
                } else {
                    rb.entity((Object)resultInputStream);
                }
                return rb.type(contentType).build();
            }
            catch (IOException e) {
                LOG.error(ERROR_PROCESSING_URL + url, (Throwable)e);
                return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type("text/plain").entity((Object)e.getMessage()).build();
            }
        }
        return null;
    }

    private Map<String, List<String>> getHeaderParamsToForward(HttpHeaders headers) {
        HashMap<String, List<String>> headerParamsToForward = new HashMap<String, List<String>>();
        for (String paramName : headers.getRequestHeaders().keySet()) {
            if (!paramName.startsWith(AMBARI_PROXY_PREFIX)) continue;
            headerParamsToForward.put(paramName.replaceAll(AMBARI_PROXY_PREFIX, ""), headers.getRequestHeader(paramName));
        }
        return headerParamsToForward;
    }
}

