/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.orm.dao.HostComponentDesiredStateDAO;
import id.onyx.obdp.server.orm.dao.HostComponentStateDAO;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostComponentDesiredStateEntity;
import id.onyx.obdp.server.orm.entities.HostComponentStateEntity;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.state.State;
import java.util.ArrayList;
import java.util.List;

@StaticallyInject
public class HostComponentSummary {
    @JsonProperty(value="service_name")
    private String serviceName;
    @JsonProperty(value="component_name")
    private String componentName;
    @JsonProperty(value="host_id")
    private Long hostId;
    @JsonProperty(value="host_name")
    private String hostName;
    @JsonProperty(value="desired_state")
    private State desiredState;
    @JsonProperty(value="current_state")
    private State currentState;
    @Inject
    private static HostDAO hostDao;
    @Inject
    private static HostComponentStateDAO hostComponentStateDao;
    @Inject
    private static HostComponentDesiredStateDAO hostComponentDesiredStateDao;

    public HostComponentSummary(String serviceName, String componentName, Long hostId, State desiredState, State currentState) {
        this.serviceName = serviceName;
        this.componentName = componentName;
        this.hostId = hostId;
        HostEntity host = hostDao.findById(hostId);
        if (host != null) {
            this.hostName = host.getHostName();
        }
        this.desiredState = desiredState;
        this.currentState = currentState;
    }

    public long getHostId() {
        return this.hostId;
    }

    public String getHostName() {
        return this.hostName == null || this.hostName.isEmpty() ? "" : this.hostName;
    }

    public State getDesiredState() {
        return this.desiredState;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public static List<HostComponentSummary> getHostComponentSummaries(String serviceName, String componentName) {
        ArrayList<HostComponentSummary> hostComponentSummaries = new ArrayList<HostComponentSummary>();
        List<HostComponentStateEntity> hostComponentStates = hostComponentStateDao.findByServiceAndComponent(serviceName, componentName);
        if (hostComponentStates != null) {
            for (HostComponentStateEntity hcse : hostComponentStates) {
                HostComponentDesiredStateEntity hcdse = hostComponentDesiredStateDao.findByServiceComponentAndHost(hcse.getServiceName(), hcse.getComponentName(), hcse.getHostName());
                if (hcdse == null) continue;
                HostComponentSummary s = new HostComponentSummary(hcse.getServiceName(), hcse.getComponentName(), hcse.getHostId(), hcdse.getDesiredState(), hcse.getCurrentState());
                hostComponentSummaries.add(s);
            }
        }
        return hostComponentSummaries;
    }

    public int hashCode() {
        int result = 31 + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result += this.componentName != null ? this.componentName.hashCode() : 0;
        return result += this.hostId != null ? this.hostId.hashCode() : 0;
    }
}

