/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.helpers.dbms;

import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.helpers.dbms.GenericDbmsHelper;
import org.eclipse.persistence.platform.database.DatabasePlatform;

public class H2Helper
extends GenericDbmsHelper {
    public H2Helper(DatabasePlatform databasePlatform) {
        super(databasePlatform);
    }

    @Override
    public boolean supportsColumnTypeChange() {
        return false;
    }

    @Override
    public String getRenameColumnStatement(String tableName, String oldName, DBAccessor.DBColumnInfo columnInfo) {
        StringBuilder builder = new StringBuilder();
        builder.append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(oldName);
        builder.append(" RENAME TO ").append(columnInfo.getName());
        return builder.toString();
    }

    @Override
    public StringBuilder writeColumnModifyString(StringBuilder builder, DBAccessor.DBColumnInfo columnInfo) {
        builder.append(" ALTER COLUMN ").append(columnInfo.getName()).append(" SET DATA TYPE ");
        this.writeColumnType(builder, columnInfo);
        return builder;
    }

    @Override
    public StringBuilder writeSetNullableString(StringBuilder builder, String tableName, DBAccessor.DBColumnInfo columnInfo, boolean nullable) {
        builder.append(" ALTER COLUMN ").append(columnInfo.getName()).append(" SET");
        String nullStatement = nullable ? " NULL" : " NOT NULL";
        builder.append(nullStatement);
        return builder;
    }

    @Override
    public String writeGetTableConstraints(String databaseName, String tableName) {
        StringBuilder statement = new StringBuilder().append("SELECT").append(" C.CONSTRAINTNAME AS CONSTRAINT_NAME,").append(" C.TYPE AS CONSTRAINT_TYPE").append(" FROM SYS.SYSCONSTRAINTS AS C, SYS.SYSTABLES AS T").append(" WHERE C.TABLEID = T.TABLEID AND T.TABLENAME = '").append(tableName).append("'");
        return statement.toString();
    }

    @Override
    public String getCopyColumnToAnotherTableStatement(String sourceTable, String sourceColumnName, String sourceIDColumnName, String targetTable, String targetColumnName, String targetIDColumnName) {
        return String.format("UPDATE %1$s a SET %3$s = (SELECT b.%4$s FROM %2$s b WHERE b.%6$s = a.%5$s LIMIT 1)", targetTable, sourceTable, targetColumnName, sourceColumnName, targetIDColumnName, sourceIDColumnName);
    }

    @Override
    public String getCopyColumnToAnotherTableStatement(String sourceTable, String sourceColumnName, String sourceIDColumnName1, String sourceIDColumnName2, String sourceIDColumnName3, String targetTable, String targetColumnName, String targetIDColumnName1, String targetIDColumnName2, String targetIDColumnName3, String sourceConditionFieldName, String condition) {
        return String.format("UPDATE %1$s a SET %3$s = (SELECT b.%4$s FROM %2$s b WHERE b.%8$s = a.%5$s AND b.%9$s = a.%6$s AND b.%10$s = a.%7$s AND b.%11$s = '%12$s'  LIMIT 1)", targetTable, sourceTable, targetColumnName, sourceColumnName, targetIDColumnName1, targetIDColumnName2, targetIDColumnName3, sourceIDColumnName1, sourceIDColumnName2, sourceIDColumnName3, sourceConditionFieldName, condition);
    }
}

