/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.helpers.dbms;

import id.onyx.obdp.server.orm.DBAccessor;
import id.onyx.obdp.server.orm.DBAccessorImpl;
import id.onyx.obdp.server.orm.helpers.dbms.DbmsHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

public class GenericDbmsHelper
implements DbmsHelper {
    protected final DatabasePlatform databasePlatform;

    public GenericDbmsHelper(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    @Override
    public boolean supportsColumnTypeChange() {
        return false;
    }

    @Override
    public String quoteObjectName(String name) {
        return "\"" + name + "\"";
    }

    @Override
    public String getRenameColumnStatement(String tableName, String oldName, DBAccessor.DBColumnInfo columnInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        this.writeAlterTableClause(stringBuilder, tableName);
        this.writeColumnRenameString(stringBuilder, oldName, columnInfo);
        return stringBuilder.toString();
    }

    @Override
    public String getAlterColumnStatement(String tableName, DBAccessor.DBColumnInfo columnInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        this.writeAlterTableClause(stringBuilder, tableName);
        this.writeColumnModifyString(stringBuilder, columnInfo);
        return stringBuilder.toString();
    }

    @Override
    public String getSetNullableStatement(String tableName, DBAccessor.DBColumnInfo columnInfo, boolean nullable) {
        StringBuilder stringBuilder = new StringBuilder();
        this.writeAlterTableClause(stringBuilder, tableName);
        this.writeSetNullableString(stringBuilder, tableName, columnInfo, nullable);
        return stringBuilder.toString();
    }

    @Override
    public String getCopyColumnToAnotherTableStatement(String sourceTable, String sourceColumnName, String sourceIDColumnName, String targetTable, String targetColumnName, String targetIDColumnName) {
        throw new UnsupportedOperationException("Column copy is not supported for generic DB");
    }

    @Override
    public String getCopyColumnToAnotherTableStatement(String sourceTable, String sourceColumnName, String sourceIDColumnName1, String sourceIDColumnName2, String sourceIDColumnName3, String targetTable, String targetColumnName, String targetIDColumnName1, String targetIDColumnName2, String targetIDColumnName3, String sourceConditionFieldName, String condition) {
        throw new UnsupportedOperationException("Column copy is not supported for generic DB");
    }

    public StringBuilder writeAlterTableClause(StringBuilder builder, String tableName) {
        builder.append("ALTER TABLE ").append(tableName).append(" ");
        return builder;
    }

    public StringBuilder writeColumnModifyString(StringBuilder builder, DBAccessor.DBColumnInfo columnInfo) {
        throw new UnsupportedOperationException("Column type modification not supported for generic DB");
    }

    public StringBuilder writeColumnRenameString(StringBuilder builder, String oldName, DBAccessor.DBColumnInfo newColumnInfo) {
        throw new UnsupportedOperationException("Column rename not supported for generic DB");
    }

    public StringBuilder writeColumnType(StringBuilder builder, DBAccessor.DBColumnInfo columnInfo) {
        FieldTypeDefinition fieldType = columnInfo.getDbType();
        if (fieldType == null) {
            fieldType = this.databasePlatform.getFieldTypeDefinition(columnInfo.getType());
        }
        if (fieldType == null) {
            throw new IllegalArgumentException("Unable to convert data type");
        }
        FieldDefinition definition = this.convertToFieldDefinition(columnInfo);
        StringWriter writer = new StringWriter();
        try {
            this.databasePlatform.printFieldTypeSize((Writer)writer, definition, fieldType, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        builder.append(writer);
        return builder;
    }

    public String writeGetTableConstraints(String databaseName, String tableName) {
        throw new UnsupportedOperationException("List of table constraints is not supported for generic DB");
    }

    public StringBuilder writeAddPrimaryKeyString(StringBuilder builder, String constraintName, String ... columnName) {
        builder.append("ADD CONSTRAINT ").append(constraintName).append(" PRIMARY KEY (").append(StringUtils.join((Object[])columnName, (String)",")).append(")");
        return builder;
    }

    public StringBuilder writeSetNullableString(StringBuilder builder, String tableName, DBAccessor.DBColumnInfo columnInfo, boolean nullable) {
        throw new UnsupportedOperationException("Column nullable modification not supported for generic DB");
    }

    public StringBuilder writeDropTableColumnStatement(StringBuilder builder, String columnName) {
        builder.append("DROP COLUMN ").append(columnName);
        return builder;
    }

    public StringBuilder writeDropPrimaryKeyStatement(StringBuilder builder, String constraintName, boolean cascade) {
        return builder.append("DROP PRIMARY KEY");
    }

    @Override
    public String getDropPrimaryKeyStatement(String tableName, String constraintName, boolean cascade) {
        StringBuilder builder = this.writeAlterTableClause(new StringBuilder(), tableName);
        return this.writeDropPrimaryKeyStatement(builder, constraintName, cascade).toString();
    }

    @Override
    public String getCreateTableStatement(String tableName, List<DBAccessor.DBColumnInfo> columns, List<String> primaryKeyColumns) {
        StringWriter stringWriter = new StringWriter();
        this.writeCreateTableStatement(stringWriter, tableName, columns, primaryKeyColumns);
        return ((Object)stringWriter).toString();
    }

    public Writer writeCreateTableStatement(Writer writer, String tableName, List<DBAccessor.DBColumnInfo> columns, List<String> primaryKeyColumns) {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        for (DBAccessor.DBColumnInfo columnInfo : columns) {
            int length;
            int n = length = columnInfo.getLength() != null ? columnInfo.getLength() : 0;
            if (primaryKeyColumns.contains(columnInfo.getName())) {
                tableDefinition.addIdentityField(columnInfo.getName(), columnInfo.getType(), length);
                continue;
            }
            FieldDefinition fieldDefinition = this.convertToFieldDefinition(columnInfo);
            tableDefinition.addField(fieldDefinition);
        }
        tableDefinition.buildCreationWriter(this.createStubAbstractSessionFromPlatform(this.databasePlatform), writer);
        return writer;
    }

    public FieldDefinition convertToFieldDefinition(DBAccessor.DBColumnInfo columnInfo) {
        int length = columnInfo.getLength() != null ? columnInfo.getLength() : 0;
        FieldDefinition fieldDefinition = new FieldDefinition(columnInfo.getName(), columnInfo.getType(), length);
        fieldDefinition.setShouldAllowNull(columnInfo.isNullable());
        if (null != columnInfo.getDefaultValue() && this.isConstraintSupportedAfterNullability()) {
            fieldDefinition.setConstraint("DEFAULT " + this.escapeParameter(columnInfo.getDefaultValue()));
        }
        return fieldDefinition;
    }

    @Override
    public String getDropUniqueConstraintStatement(String tableName, String constraintName) {
        UniqueKeyConstraint uniqueKeyConstraint = new UniqueKeyConstraint();
        uniqueKeyConstraint.setName(constraintName);
        StringWriter writer = new StringWriter();
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        tableDefinition.buildUniqueConstraintDeletionWriter(this.createStubAbstractSessionFromPlatform(this.databasePlatform), uniqueKeyConstraint, (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public String getTableConstraintsStatement(String databaseName, String tablename) {
        return this.writeGetTableConstraints(databaseName, tablename);
    }

    @Override
    public String getCreateIndexStatement(String indexName, String tableName, String ... columnNames) {
        return this.getCreateIndexStatement(indexName, tableName, false, columnNames);
    }

    @Override
    public String getCreateIndexStatement(String indexName, String tableName, boolean isUnique, String ... columnNames) {
        String createIndex = this.databasePlatform.buildCreateIndex(tableName, indexName, "", isUnique, columnNames);
        return createIndex;
    }

    @Override
    public String getColumnUpdateStatementWhereColumnIsNull(String tableName, String setColumnName, String conditionColumnName) {
        return "UPDATE " + tableName + " SET " + setColumnName + "=? WHERE " + conditionColumnName + " IS NULL";
    }

    @Override
    public String getDropIndexStatement(String indexName, String tableName) {
        String dropIndex = this.databasePlatform.buildDropIndex(tableName, indexName);
        return dropIndex;
    }

    @Override
    public String getAddUniqueConstraintStatement(String tableName, String constraintName, String ... columnNames) {
        UniqueKeyConstraint uniqueKeyConstraint = new UniqueKeyConstraint();
        uniqueKeyConstraint.setName(constraintName);
        for (String columnName : columnNames) {
            uniqueKeyConstraint.addSourceField(columnName);
        }
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        StringWriter writer = new StringWriter();
        tableDefinition.buildUniqueConstraintCreationWriter(this.createStubAbstractSessionFromPlatform(this.databasePlatform), uniqueKeyConstraint, (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public String getAddPrimaryKeyConstraintStatement(String tableName, String constraintName, String ... columnName) {
        StringBuilder builder = this.writeAlterTableClause(new StringBuilder(), tableName);
        builder = this.writeAddPrimaryKeyString(builder, constraintName, columnName);
        return builder.toString();
    }

    @Override
    public String getAddForeignKeyStatement(String tableName, String constraintName, List<String> keyColumns, String referenceTableName, List<String> referenceColumns, boolean shouldCascadeOnDelete) {
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
        foreignKeyConstraint.setName(constraintName);
        foreignKeyConstraint.setTargetTable(referenceTableName);
        foreignKeyConstraint.setSourceFields(keyColumns);
        foreignKeyConstraint.setTargetFields(referenceColumns);
        foreignKeyConstraint.setShouldCascadeOnDelete(shouldCascadeOnDelete);
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        StringWriter writer = new StringWriter();
        tableDefinition.buildConstraintCreationWriter(this.createStubAbstractSessionFromPlatform(this.databasePlatform), foreignKeyConstraint, (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public String getAddColumnStatement(String tableName, DBAccessor.DBColumnInfo columnInfo) {
        StringWriter writer = new StringWriter();
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        tableDefinition.buildAddFieldWriter(this.createStubAbstractSessionFromPlatform(this.databasePlatform), this.convertToFieldDefinition(columnInfo), (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public String getDropTableColumnStatement(String tableName, String columnName) {
        StringBuilder builder = this.writeAlterTableClause(new StringBuilder(), tableName);
        return this.writeDropTableColumnStatement(builder, columnName).toString();
    }

    @Override
    public String getRenameColumnStatement(String tableName, String oldColumnName, String newColumnName) {
        throw new UnsupportedOperationException("Rename operation not supported.");
    }

    @Override
    public String getDropTableStatement(String tableName) {
        StringWriter writer = new StringWriter();
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        tableDefinition.buildDeletionWriter(this.createStubAbstractSessionFromPlatform(this.databasePlatform), (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public String getDropFKConstraintStatement(String tableName, String constraintName) {
        StringWriter writer = new StringWriter();
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
        foreignKeyConstraint.setName(constraintName);
        foreignKeyConstraint.setTargetTable(tableName);
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        tableDefinition.buildConstraintDeletionWriter(this.createStubAbstractSessionFromPlatform(this.databasePlatform), foreignKeyConstraint, (Writer)writer);
        return ((Object)writer).toString();
    }

    @Override
    public String getDropSequenceStatement(String sequenceName) {
        StringWriter writer = new StringWriter();
        String defaultStmt = String.format("DROP sequence %s", sequenceName);
        try {
            Writer w = this.databasePlatform.buildSequenceObjectDeletionWriter((Writer)writer, sequenceName);
            return w != null ? w.toString() : defaultStmt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return defaultStmt;
        }
    }

    public AbstractSession createStubAbstractSessionFromPlatform(final DatabasePlatform databasePlatform) {
        return new AbstractSession(){

            public Platform getDatasourcePlatform() {
                return databasePlatform;
            }

            public DatabasePlatform getPlatform() {
                return databasePlatform;
            }
        };
    }

    @Override
    public boolean isConstraintSupportedAfterNullability() {
        return true;
    }

    private String escapeParameter(Object value) {
        return DBAccessorImpl.escapeParameter(value, this.databasePlatform);
    }
}

