/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.helpers;

import com.google.common.collect.Iterables;
import java.util.Collection;

public class SQLOperations {
    public static <T> int batch(Collection<T> collection, int batchSize, BatchOperation<T> callback) {
        if (collection == null || collection.isEmpty() || batchSize == 0) {
            return 0;
        }
        int totalSize = collection.size();
        int totalChunks = (int)Math.ceil((float)totalSize / (float)batchSize);
        int currentChunk = 0;
        int resultSum = 0;
        for (Collection chunk : Iterables.partition(collection, (int)batchSize)) {
            resultSum += callback.chunk(chunk, ++currentChunk, totalChunks, totalSize);
        }
        return resultSum;
    }

    public static interface BatchOperation<T> {
        public int chunk(Collection<T> var1, int var2, int var3, int var4);
    }
}

