/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutUserWidgetEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="widget_layout")
@TableGenerator(name="widget_layout_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="widget_layout_id_seq", initialValue=0, uniqueConstraints={@UniqueConstraint(columnNames={"layout_name", "cluster_id"})})
@NamedQueries(value={@NamedQuery(name="WidgetLayoutEntity.findAll", query="SELECT widgetLayout FROM WidgetLayoutEntity widgetLayout"), @NamedQuery(name="WidgetLayoutEntity.findByCluster", query="SELECT widgetLayout FROM WidgetLayoutEntity widgetLayout WHERE widgetLayout.clusterId = :clusterId"), @NamedQuery(name="WidgetLayoutEntity.findBySectionName", query="SELECT widgetLayout FROM WidgetLayoutEntity widgetLayout WHERE widgetLayout.sectionName = :sectionName"), @NamedQuery(name="WidgetLayoutEntity.findByName", query="SELECT widgetLayout FROM WidgetLayoutEntity widgetLayout WHERE widgetLayout.clusterId = :clusterId AND widgetLayout.layoutName = :layoutName AND widgetLayout.userName = :userName")})
public class WidgetLayoutEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="widget_layout_id_generator")
    @Column(name="id", nullable=false, updatable=false)
    private Long id;
    @Column(name="layout_name", nullable=false, length=255)
    private String layoutName;
    @Column(name="section_name", nullable=false, length=255)
    private String sectionName;
    @Column(name="cluster_id", nullable=false)
    private Long clusterId;
    @Column(name="user_name", nullable=false)
    private String userName;
    @Column(name="scope", nullable=false)
    private String scope;
    @Column(name="display_name")
    private String displayName;
    @ManyToOne
    @JoinColumn(name="cluster_id", referencedColumnName="cluster_id", nullable=false, updatable=false, insertable=false)
    private ClusterEntity clusterEntity;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="widgetLayout", orphanRemoval=true)
    @OrderBy(value="widgetOrder")
    private List<WidgetLayoutUserWidgetEntity> listWidgetLayoutUserWidgetEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLayoutName() {
        return this.layoutName;
    }

    public void setLayoutName(String layoutName) {
        this.layoutName = layoutName;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public ClusterEntity getClusterEntity() {
        return this.clusterEntity;
    }

    public void setClusterEntity(ClusterEntity clusterEntity) {
        this.clusterEntity = clusterEntity;
    }

    public List<WidgetLayoutUserWidgetEntity> getListWidgetLayoutUserWidgetEntity() {
        return this.listWidgetLayoutUserWidgetEntity;
    }

    public void setListWidgetLayoutUserWidgetEntity(List<WidgetLayoutUserWidgetEntity> listWidgetLayoutUserWidgetEntity) {
        this.listWidgetLayoutUserWidgetEntity = listWidgetLayoutUserWidgetEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetLayoutEntity that = (WidgetLayoutEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

