/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewEntityEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceDataEntity;
import id.onyx.obdp.server.orm.entities.ViewInstancePropertyEntity;
import id.onyx.obdp.server.orm.entities.ViewParameterEntity;
import id.onyx.obdp.server.orm.entities.ViewURLEntity;
import id.onyx.obdp.server.security.SecurityHelper;
import id.onyx.obdp.server.security.SecurityHelperImpl;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.view.ViewContextImpl;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.server.view.configuration.InstanceConfig;
import id.onyx.obdp.server.view.validation.InstanceValidationResultImpl;
import id.onyx.obdp.server.view.validation.ValidationException;
import id.onyx.obdp.server.view.validation.ValidationResultImpl;
import id.onyx.obdp.view.ClusterType;
import id.onyx.obdp.view.ResourceProvider;
import id.onyx.obdp.view.ViewContext;
import id.onyx.obdp.view.ViewDefinition;
import id.onyx.obdp.view.ViewInstanceDefinition;
import id.onyx.obdp.view.migration.ViewDataMigrationContext;
import id.onyx.obdp.view.migration.ViewDataMigrator;
import id.onyx.obdp.view.validation.ValidationResult;
import id.onyx.obdp.view.validation.Validator;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@Table(name="viewinstance", uniqueConstraints={@UniqueConstraint(name="UQ_viewinstance_name", columnNames={"view_name", "name"})})
@NamedQueries(value={@NamedQuery(name="allViewInstances", query="SELECT viewInstance FROM ViewInstanceEntity viewInstance"), @NamedQuery(name="viewInstanceByResourceId", query="SELECT viewInstance FROM ViewInstanceEntity viewInstance WHERE viewInstance.resource.id=:resourceId"), @NamedQuery(name="getResourceIdByViewInstance", query="SELECT viewInstance.resource FROM ViewInstanceEntity viewInstance WHERE viewInstance.viewName = :viewName AND viewInstance.name = :instanceName")})
@TableGenerator(name="view_instance_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="view_instance_id_seq", initialValue=1)
@Entity
public class ViewInstanceEntity
implements ViewInstanceDefinition {
    @Id
    @Column(name="view_instance_id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="view_instance_id_generator")
    private Long viewInstanceId;
    @Column(name="view_name", nullable=false, insertable=false, updatable=false)
    private String viewName;
    @Column(name="name", nullable=false, insertable=true, updatable=false)
    private String name;
    @Column
    @Basic
    private String label;
    @Column
    @Basic
    private String description;
    @Column(name="cluster_handle", nullable=true)
    private Long clusterHandle;
    @Enumerated(value=EnumType.STRING)
    @Column(name="cluster_type", nullable=false, length=100)
    private ClusterType clusterType = ClusterType.LOCAL_OBDP;
    @Column
    @Basic
    private char visible;
    @Column
    @Basic
    private String icon;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="short_url", referencedColumnName="url_id", nullable=true)})
    private ViewURLEntity viewUrl;
    @Column
    @Basic
    private String icon64;
    @Column(name="xml_driven")
    @Basic
    private char xmlDriven = (char)78;
    @Column(name="alter_names", nullable=false)
    @Basic
    private Integer alterNames;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="viewInstance")
    private Collection<ViewInstancePropertyEntity> properties = new HashSet<ViewInstancePropertyEntity>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="viewInstance")
    private Collection<ViewInstanceDataEntity> data = new HashSet<ViewInstanceDataEntity>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="viewInstance")
    private Collection<ViewEntityEntity> entities = new HashSet<ViewEntityEntity>();
    @ManyToOne
    @JoinColumn(name="view_name", referencedColumnName="view_name", nullable=false)
    private ViewEntity view;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="resource_id", referencedColumnName="resource_id", nullable=false)})
    private ResourceEntity resource;
    @Transient
    private final InstanceConfig instanceConfig;
    @Transient
    private final Map<Resource.Type, ResourceProvider> resourceProviders = new HashMap<Resource.Type, ResourceProvider>();
    @Transient
    private final Map<String, Object> services = new HashMap<String, Object>();
    @Transient
    private SecurityHelper securityHelper = SecurityHelperImpl.getInstance();
    @Transient
    private ViewDataMigrator dataMigrator;

    public ViewInstanceEntity() {
        this.instanceConfig = null;
        this.alterNames = 1;
    }

    public ViewInstanceEntity(ViewEntity view, InstanceConfig instanceConfig) {
        this.name = instanceConfig.getName();
        this.instanceConfig = instanceConfig;
        this.view = view;
        this.viewName = view.getName();
        this.description = instanceConfig.getDescription();
        this.clusterHandle = null;
        this.visible = (char)(instanceConfig.isVisible() ? 89 : 78);
        this.alterNames = 1;
        this.clusterType = ClusterType.LOCAL_OBDP;
        String label = instanceConfig.getLabel();
        this.label = label == null || label.length() == 0 ? view.getLabel() : label;
        String icon = instanceConfig.getIcon();
        this.icon = icon == null || icon.length() == 0 ? view.getIcon() : icon;
        String icon64 = instanceConfig.getIcon64();
        this.icon64 = icon64 == null || icon64.length() == 0 ? view.getIcon64() : icon64;
    }

    public ViewInstanceEntity(ViewEntity view, String name) {
        this(view, name, view.getLabel());
    }

    public ViewInstanceEntity(ViewEntity view, String name, String label) {
        this.name = name;
        this.instanceConfig = null;
        this.view = view;
        this.viewName = view.getName();
        this.description = null;
        this.clusterHandle = null;
        this.visible = (char)89;
        this.alterNames = 1;
        this.label = label;
    }

    public String getInstanceName() {
        return this.name;
    }

    public String getViewName() {
        return this.viewName;
    }

    public Map<String, String> getPropertyMap() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (ViewInstancePropertyEntity viewInstancePropertyEntity : this.getProperties()) {
            propertyMap.put(viewInstancePropertyEntity.getName(), viewInstancePropertyEntity.getValue());
        }
        for (ViewParameterEntity viewParameterEntity : this.view.getParameters()) {
            String parameterName = viewParameterEntity.getName();
            if (propertyMap.containsKey(parameterName)) continue;
            propertyMap.put(parameterName, viewParameterEntity.getDefaultValue());
        }
        return propertyMap;
    }

    public Map<String, String> getInstanceDataMap() {
        HashMap<String, String> applicationData = new HashMap<String, String>();
        String user = this.getCurrentUserName();
        for (ViewInstanceDataEntity viewInstanceDataEntity : this.data) {
            if (!viewInstanceDataEntity.getUser().equals(user)) continue;
            applicationData.put(viewInstanceDataEntity.getName(), viewInstanceDataEntity.getValue());
        }
        return applicationData;
    }

    public ViewDefinition getViewDefinition() {
        return this.view;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getClusterHandle() {
        return this.clusterHandle;
    }

    public boolean isVisible() {
        return this.visible == 'y' || this.visible == 'Y';
    }

    public Long getViewInstanceId() {
        return this.viewInstanceId;
    }

    public void setViewInstanceId(Long viewInstanceId) {
        this.viewInstanceId = viewInstanceId;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setClusterHandle(Long clusterHandle) {
        this.clusterHandle = clusterHandle;
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(ClusterType clusterType) {
        this.clusterType = clusterType;
    }

    public void setVisible(boolean visible) {
        this.visible = (char)(visible ? 89 : 78);
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon64() {
        return this.icon64;
    }

    public void setIcon64(String icon64) {
        this.icon64 = icon64;
    }

    public boolean isXmlDriven() {
        return this.xmlDriven == 'y' || this.xmlDriven == 'Y';
    }

    public void setXmlDriven(boolean xmlDriven) {
        this.xmlDriven = (char)(xmlDriven ? 89 : 78);
    }

    public boolean alterNames() {
        return this.alterNames == 1;
    }

    public void setAlterNames(boolean alterNames) {
        this.alterNames = alterNames ? 1 : 0;
    }

    public Collection<ViewInstancePropertyEntity> getProperties() {
        return this.properties;
    }

    public void putProperty(String key, String value) {
        this.removeProperty(key);
        ViewInstancePropertyEntity viewInstancePropertyEntity = new ViewInstancePropertyEntity();
        viewInstancePropertyEntity.setViewName(this.viewName);
        viewInstancePropertyEntity.setViewInstanceName(this.name);
        viewInstancePropertyEntity.setName(key);
        viewInstancePropertyEntity.setValue(value);
        viewInstancePropertyEntity.setViewInstanceEntity(this);
        this.properties.add(viewInstancePropertyEntity);
    }

    public void removeProperty(String key) {
        ViewInstancePropertyEntity entity = this.getProperty(key);
        if (entity != null) {
            this.properties.remove(entity);
        }
    }

    public ViewInstancePropertyEntity getProperty(String key) {
        for (ViewInstancePropertyEntity viewInstancePropertyEntity : this.properties) {
            if (!viewInstancePropertyEntity.getName().equals(key)) continue;
            return viewInstancePropertyEntity;
        }
        return null;
    }

    public void setProperties(Collection<ViewInstancePropertyEntity> properties) {
        this.properties = properties;
    }

    public Collection<ViewInstanceDataEntity> getData() {
        return this.data;
    }

    public void setData(Collection<ViewInstanceDataEntity> data) {
        this.data = data;
    }

    public Collection<ViewEntityEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<ViewEntityEntity> entities) {
        this.entities = entities;
    }

    public void putInstanceData(String key, String value) {
        this.removeInstanceData(key);
        ViewInstanceDataEntity viewInstanceDataEntity = new ViewInstanceDataEntity();
        viewInstanceDataEntity.setViewName(this.viewName);
        viewInstanceDataEntity.setViewInstanceName(this.name);
        viewInstanceDataEntity.setName(key);
        viewInstanceDataEntity.setUser(this.getCurrentUserName());
        viewInstanceDataEntity.setValue(value);
        viewInstanceDataEntity.setViewInstanceEntity(this);
        this.data.add(viewInstanceDataEntity);
    }

    public void removeInstanceData(String key) {
        ViewInstanceDataEntity entity = this.getInstanceData(key);
        if (entity != null) {
            this.data.remove(entity);
        }
    }

    public ViewInstanceDataEntity getInstanceData(String key) {
        String user = this.getCurrentUserName();
        for (ViewInstanceDataEntity viewInstanceDataEntity : this.data) {
            if (!viewInstanceDataEntity.getName().equals(key) || !viewInstanceDataEntity.getUser().equals(user)) continue;
            return viewInstanceDataEntity;
        }
        return null;
    }

    public ViewEntity getViewEntity() {
        return this.view;
    }

    public void setViewEntity(ViewEntity view) {
        this.view = view;
    }

    public InstanceConfig getConfiguration() {
        return this.instanceConfig;
    }

    public void addResourceProvider(Resource.Type type, ResourceProvider provider) {
        this.resourceProviders.put(type, provider);
    }

    public ResourceProvider getResourceProvider(Resource.Type type) {
        return this.resourceProviders.get(type);
    }

    public ResourceProvider getResourceProvider(String type) {
        String typeName = this.view.getQualifiedResourceTypeName(type);
        return this.resourceProviders.get(Resource.Type.valueOf(typeName));
    }

    public void addService(String pluralName, Object service) {
        this.services.put(pluralName, service);
    }

    public Object getService(String pluralName) {
        return this.services.get(pluralName);
    }

    public String getContextPath() {
        return ViewInstanceEntity.getContextPath(this.view.getCommonName(), this.view.getVersion(), this.getName());
    }

    public static String getContextPath(String viewName, String version, String viewInstanceName) {
        return "/views/" + viewName + "/" + version + "/" + viewInstanceName;
    }

    public String getUsername() {
        return AuthorizationHelper.resolveLoginAliasToUserName(this.securityHelper.getCurrentUserName());
    }

    public ResourceEntity getResource() {
        return this.resource;
    }

    public void setResource(ResourceEntity resource) {
        this.resource = resource;
    }

    public ViewDataMigrator getDataMigrator(ViewDataMigrationContext dataMigrationContext) throws ClassNotFoundException {
        if (this.view != null && this.dataMigrator == null && this.view.getConfiguration().getDataMigrator() != null) {
            ClassLoader cl = this.view.getClassLoader();
            this.dataMigrator = ViewInstanceEntity.getDataMigrator(this.view.getConfiguration().getDataMigratorClass(cl), new ViewContextImpl(this.view, ViewRegistry.getInstance()), dataMigrationContext);
        }
        return this.dataMigrator;
    }

    private static ViewDataMigrator getDataMigrator(Class<? extends ViewDataMigrator> clazz, final ViewContext viewContext, final ViewDataMigrationContext dataMigrationContext) {
        Injector viewInstanceInjector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ViewContext.class).toInstance((Object)viewContext);
                this.bind(ViewDataMigrationContext.class).toInstance((Object)dataMigrationContext);
            }
        }});
        return (ViewDataMigrator)viewInstanceInjector.getInstance(clazz);
    }

    public void validate(ViewEntity viewEntity, Validator.ValidationContext context) throws ValidationException {
        InstanceValidationResultImpl result = this.getValidationResult(viewEntity, context);
        if (!result.isValid()) {
            throw new ValidationException(result.toJson());
        }
    }

    public InstanceValidationResultImpl getValidationResult(ViewEntity viewEntity, Validator.ValidationContext context) throws IllegalStateException {
        HashMap<String, ValidationResult> propertyResults = new HashMap<String, ValidationResult>();
        if (context.equals((Object)Validator.ValidationContext.PRE_CREATE) || context.equals((Object)Validator.ValidationContext.PRE_UPDATE)) {
            HashSet<String> requiredParameterNames = new HashSet<String>();
            for (ViewParameterEntity parameter : viewEntity.getParameters()) {
                if (!parameter.isRequired() || parameter.getClusterConfig() != null) continue;
                requiredParameterNames.add(parameter.getName());
            }
            Map<String, String> propertyMap = this.getPropertyMap();
            for (Map.Entry entry : propertyMap.entrySet()) {
                if (entry.getValue() == null) continue;
                requiredParameterNames.remove(entry.getKey());
            }
            for (String string : requiredParameterNames) {
                propertyResults.put(string, new ValidationResultImpl(false, "No property values exist for the required parameter " + string + "."));
            }
        }
        ValidationResult instanceResult = null;
        Validator validator = viewEntity.getValidator();
        if (validator != null) {
            instanceResult = validator.validateInstance((ViewInstanceDefinition)this, context);
            for (String string : this.getPropertyMap().keySet()) {
                if (propertyResults.containsKey(string)) continue;
                propertyResults.put(string, ValidationResultImpl.create(validator.validateProperty(string, (ViewInstanceDefinition)this, context)));
            }
        }
        return new InstanceValidationResultImpl(ValidationResultImpl.create(instanceResult), propertyResults);
    }

    public String getCurrentUserName() {
        String currentUserName = this.getUsername();
        return currentUserName == null || currentUserName.length() == 0 ? " " : currentUserName;
    }

    protected void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewInstanceEntity that = (ViewInstanceEntity)o;
        return this.name.equals(that.name) && this.viewName.equals(that.viewName);
    }

    public int hashCode() {
        int result = this.viewName.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public ViewURLEntity getViewUrl() {
        return this.viewUrl;
    }

    public void setViewUrl(ViewURLEntity viewUrl) {
        this.viewUrl = viewUrl;
    }

    public void clearUrl() {
        this.viewUrl = null;
    }

    public String toString() {
        return "ViewInstanceEntity{viewInstanceId=" + this.viewInstanceId + ", viewName='" + this.viewName + "', name='" + this.name + "', label='" + this.label + "'}";
    }

    public static class ViewInstanceVersionDTO {
        private final String viewName;
        private final String version;
        private final String instanceName;

        public ViewInstanceVersionDTO(String viewName, String version, String instanceName) {
            this.viewName = viewName;
            this.version = version;
            this.instanceName = instanceName;
        }

        public String getViewName() {
            return this.viewName;
        }

        public String getVersion() {
            return this.version;
        }

        public String getInstanceName() {
            return this.instanceName;
        }
    }
}

