/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.orm.entities.ViewParameterEntity;
import id.onyx.obdp.server.orm.entities.ViewResourceEntity;
import id.onyx.obdp.server.view.ViewSubResourceDefinition;
import id.onyx.obdp.server.view.configuration.ParameterConfig;
import id.onyx.obdp.server.view.configuration.ResourceConfig;
import id.onyx.obdp.server.view.configuration.ViewConfig;
import id.onyx.obdp.view.View;
import id.onyx.obdp.view.ViewDefinition;
import id.onyx.obdp.view.validation.Validator;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Table(name="viewmain")
@NamedQuery(name="allViews", query="SELECT view FROM ViewEntity view")
@Entity
public class ViewEntity
implements ViewDefinition {
    public static final String AMBARI_ONLY = "OBDP-ONLY";
    @Id
    @Column(name="view_name", nullable=false, insertable=true, updatable=false, unique=true, length=100)
    private String name;
    @Column
    @Basic
    private String label;
    @Column
    @Basic
    private String description;
    @Column
    @Basic
    private String icon;
    @Column
    @Basic
    private String icon64;
    @Column
    @Basic
    private String version;
    @Column
    @Basic
    private String build;
    @Column
    @Basic
    private String archive;
    @Column
    @Basic
    private String mask;
    @Column(name="system_view")
    @Basic
    private Integer system;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="view")
    private Collection<ViewParameterEntity> parameters = new HashSet<ViewParameterEntity>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="view")
    private Collection<ViewResourceEntity> resources = new HashSet<ViewResourceEntity>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="view")
    private Collection<ViewInstanceEntity> instances = new HashSet<ViewInstanceEntity>();
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="resource_type_id", referencedColumnName="resource_type_id", nullable=false)})
    private Collection<PermissionEntity> permissions = new HashSet<PermissionEntity>();
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="resource_type_id", referencedColumnName="resource_type_id", nullable=false)})
    private ResourceTypeEntity resourceType;
    @Transient
    private ViewConfig configuration;
    @Transient
    private final Configuration ambariConfiguration;
    @Transient
    private final Resource.Type externalResourceType;
    @Transient
    private ClassLoader classLoader = null;
    @Transient
    private final Map<Resource.Type, ResourceProvider> resourceProviders = new HashMap<Resource.Type, ResourceProvider>();
    @Transient
    private final Map<Resource.Type, ViewSubResourceDefinition> resourceDefinitions = new HashMap<Resource.Type, ViewSubResourceDefinition>();
    @Transient
    private final Map<Resource.Type, ResourceConfig> resourceConfigurations = new HashMap<Resource.Type, ResourceConfig>();
    @Transient
    private String commonName = null;
    @Transient
    private View view = null;
    @Transient
    private Validator validator = null;
    @Transient
    private ViewDefinition.ViewStatus status = ViewDefinition.ViewStatus.PENDING;
    @Transient
    private String statusDetail;
    @Transient
    private boolean clusterConfigurable;

    public ViewEntity() {
        this.configuration = null;
        this.ambariConfiguration = null;
        this.archive = null;
        this.externalResourceType = null;
        this.system = 0;
        this.clusterConfigurable = false;
    }

    public ViewEntity(ViewConfig configuration, Configuration ambariConfiguration, String archivePath) {
        this.setConfiguration(configuration);
        this.ambariConfiguration = ambariConfiguration;
        this.archive = archivePath;
        String version = configuration.getVersion();
        this.name = ViewEntity.getViewName(configuration.getName(), version);
        this.label = configuration.getLabel();
        this.description = configuration.getDescription();
        this.version = version;
        this.build = configuration.getBuild();
        this.mask = configuration.getMasker();
        this.icon = configuration.getIcon();
        this.icon64 = configuration.getIcon64();
        this.system = configuration.isSystem() ? 1 : 0;
        this.externalResourceType = new Resource.Type(this.getQualifiedResourceTypeName("resources"));
    }

    public String getViewName() {
        return this.getCommonName();
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public ViewDefinition.ViewStatus getStatus() {
        return this.status;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public String getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized String getCommonName() {
        if (this.commonName == null) {
            this.commonName = this.name.replaceAll("\\{(.+)\\}", "");
        }
        return this.commonName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon64() {
        return this.icon64;
    }

    public void setIcon64(String icon64) {
        this.icon64 = icon64;
    }

    public Collection<ViewParameterEntity> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ViewParameterEntity> parameters) {
        this.parameters = parameters;
    }

    public Collection<PermissionEntity> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<PermissionEntity> permissions) {
        this.permissions = permissions;
    }

    public PermissionEntity getPermission(String permissionName) {
        for (PermissionEntity permissionEntity : this.permissions) {
            if (!permissionEntity.getPermissionName().equals(permissionName)) continue;
            return permissionEntity;
        }
        return null;
    }

    public Collection<ViewResourceEntity> getResources() {
        return this.resources;
    }

    public void setResources(Collection<ViewResourceEntity> resources) {
        this.resources = resources;
    }

    public Collection<ViewInstanceEntity> getInstances() {
        return this.instances;
    }

    public void setInstances(Collection<ViewInstanceEntity> instances) {
        this.instances = instances;
    }

    public void addInstanceDefinition(ViewInstanceEntity viewInstanceDefinition) {
        this.removeInstanceDefinition(viewInstanceDefinition.getName());
        this.instances.add(viewInstanceDefinition);
    }

    public void removeInstanceDefinition(String instanceName) {
        ViewInstanceEntity entity = this.getInstanceDefinition(instanceName);
        if (entity != null) {
            this.instances.remove(entity);
        }
    }

    public ViewInstanceEntity getInstanceDefinition(String instanceName) {
        for (ViewInstanceEntity viewInstanceEntity : this.instances) {
            if (!viewInstanceEntity.getName().equals(instanceName)) continue;
            return viewInstanceEntity;
        }
        return null;
    }

    public String getArchive() {
        return this.archive;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public String getAmbariProperty(String key) {
        return this.ambariConfiguration.getProperty(key);
    }

    public Configuration getAmbariConfiguration() {
        return this.ambariConfiguration;
    }

    public String getQualifiedResourceTypeName(String resourceTypeName) {
        return this.getName() + "/" + resourceTypeName;
    }

    public Resource.Type getExternalResourceType() {
        return this.externalResourceType;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addResourceProvider(Resource.Type type, ResourceProvider provider) {
        this.resourceProviders.put(type, provider);
    }

    public ResourceProvider getResourceProvider(Resource.Type type) {
        return this.resourceProviders.get(type);
    }

    public void addResourceDefinition(ViewSubResourceDefinition definition) {
        this.resourceDefinitions.put(definition.getType(), definition);
    }

    public ViewSubResourceDefinition getResourceDefinition(Resource.Type type) {
        return this.resourceDefinitions.get(type);
    }

    public Map<Resource.Type, ViewSubResourceDefinition> getResourceDefinitions() {
        return this.resourceDefinitions;
    }

    public void addResourceConfiguration(Resource.Type type, ResourceConfig config) {
        this.resourceConfigurations.put(type, config);
    }

    public Map<Resource.Type, ResourceConfig> getResourceConfigurations() {
        return this.resourceConfigurations;
    }

    public Set<Resource.Type> getViewResourceTypes() {
        return this.resourceProviders.keySet();
    }

    public void setConfiguration(ViewConfig configuration) {
        this.configuration = configuration;
        this.clusterConfigurable = false;
        if (configuration.getClusterConfigOptions() != null && configuration.getClusterConfigOptions().equals(AMBARI_ONLY)) {
            this.clusterConfigurable = true;
            return;
        }
        for (ParameterConfig parameterConfig : configuration.getParameters()) {
            String clusterConfig = parameterConfig.getClusterConfig();
            if (clusterConfig == null || clusterConfig.isEmpty()) continue;
            this.clusterConfigurable = true;
            return;
        }
    }

    public ViewConfig getConfiguration() {
        return this.configuration;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public boolean hasValidator() {
        return this.validator != null;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public boolean isSystem() {
        return this.system == 1;
    }

    public void setSystem(boolean required) {
        this.system = required ? 1 : 0;
    }

    public ResourceTypeEntity getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEntity resourceType) {
        this.resourceType = resourceType;
    }

    public void setStatus(ViewDefinition.ViewStatus status) {
        this.status = status;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public boolean isClusterConfigurable() {
        return this.clusterConfigurable;
    }

    public boolean isDeployed() {
        return this.status.equals((Object)ViewDefinition.ViewStatus.DEPLOYED);
    }

    public static String getViewName(String name, String version) {
        return name + "{" + version + "}";
    }

    public String toString() {
        return "ViewEntity{name='" + this.name + "', label='" + this.label + "', description='" + this.description + "'}";
    }
}

