/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Table(name="users", uniqueConstraints={@UniqueConstraint(columnNames={"user_name"})})
@Entity
@NamedQueries(value={@NamedQuery(name="userByName", query="SELECT user_entity from UserEntity user_entity where lower(user_entity.userName)=lower(:username)")})
@TableGenerator(name="user_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="user_id_seq", initialValue=2, allocationSize=500)
public class UserEntity {
    @Id
    @Column(name="user_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="user_id_generator")
    private Integer userId;
    @Column(name="user_name", nullable=false)
    private String userName;
    @Column(name="create_time", nullable=false)
    @Basic
    private long createTime;
    @Column(name="active", nullable=false)
    private Integer active = 1;
    @Column(name="consecutive_failures", nullable=false)
    private Integer consecutiveFailures = 0;
    @Column(name="display_name")
    private String displayName;
    @Column(name="local_username")
    private String localUsername;
    @Version
    @Column(name="version")
    private Long version;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL})
    private Set<MemberEntity> memberEntities = new HashSet<MemberEntity>();
    @OneToOne
    @JoinColumns(value={@JoinColumn(name="principal_id", referencedColumnName="principal_id", nullable=false)})
    private PrincipalEntity principal;
    @Column(name="active_widget_layouts")
    private String activeWidgetLayouts;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<UserAuthenticationEntity> authenticationEntities = new ArrayList<UserAuthenticationEntity>();

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName == null ? null : userName.toLowerCase();
    }

    public Integer getConsecutiveFailures() {
        return this.consecutiveFailures;
    }

    public void setConsecutiveFailures(Integer consecutiveFailures) {
        this.consecutiveFailures = consecutiveFailures;
    }

    public void incrementConsecutiveFailures() {
        Integer n = this.consecutiveFailures;
        this.consecutiveFailures = this.consecutiveFailures + 1;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getLocalUsername() {
        return this.localUsername;
    }

    public void setLocalUsername(String localUsername) {
        this.localUsername = localUsername;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Set<MemberEntity> getMemberEntities() {
        return this.memberEntities;
    }

    public void setMemberEntities(Set<MemberEntity> memberEntities) {
        this.memberEntities = memberEntities;
    }

    public Boolean getActive() {
        return this.active == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public void setActive(Boolean active) {
        this.active = active == null ? null : Integer.valueOf(active != false ? 1 : 0);
    }

    public PrincipalEntity getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PrincipalEntity principal) {
        this.principal = principal;
    }

    public String getActiveWidgetLayouts() {
        return this.activeWidgetLayouts;
    }

    public void setActiveWidgetLayouts(String activeWidgetLayouts) {
        this.activeWidgetLayouts = activeWidgetLayouts;
    }

    public List<UserAuthenticationEntity> getAuthenticationEntities() {
        return this.authenticationEntities;
    }

    public void setAuthenticationEntities(List<UserAuthenticationEntity> authenticationEntities) {
        if (this.authenticationEntities != authenticationEntities) {
            this.authenticationEntities.clear();
            if (authenticationEntities != null) {
                this.authenticationEntities.addAll(authenticationEntities);
            }
        }
    }

    @PrePersist
    protected void onCreate() {
        this.createTime = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.userId, (Object)that.userId);
        equalsBuilder.append((Object)this.userName, (Object)that.userName);
        equalsBuilder.append((Object)this.displayName, (Object)that.displayName);
        equalsBuilder.append((Object)this.localUsername, (Object)that.localUsername);
        equalsBuilder.append((Object)this.consecutiveFailures, (Object)that.consecutiveFailures);
        equalsBuilder.append((Object)this.active, (Object)that.active);
        equalsBuilder.append(this.createTime, that.createTime);
        equalsBuilder.append((Object)this.version, (Object)that.version);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.userId);
        hashCodeBuilder.append((Object)this.userName);
        hashCodeBuilder.append((Object)this.displayName);
        hashCodeBuilder.append((Object)this.localUsername);
        hashCodeBuilder.append((Object)this.consecutiveFailures);
        hashCodeBuilder.append((Object)this.active);
        hashCodeBuilder.append(this.createTime);
        hashCodeBuilder.append((Object)this.version);
        return hashCodeBuilder.toHashCode();
    }
}

