/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Table(name="user_authentication")
@Entity
@NamedQueries(value={@NamedQuery(name="UserAuthenticationEntity.findAll", query="SELECT entity FROM UserAuthenticationEntity entity"), @NamedQuery(name="UserAuthenticationEntity.findByType", query="SELECT entity FROM UserAuthenticationEntity entity where lower(entity.authenticationType)=lower(:authenticationType)"), @NamedQuery(name="UserAuthenticationEntity.findByTypeAndKey", query="SELECT entity FROM UserAuthenticationEntity entity where lower(entity.authenticationType)=lower(:authenticationType) and entity.authenticationKey=:authenticationKey"), @NamedQuery(name="UserAuthenticationEntity.findByUser", query="SELECT entity FROM UserAuthenticationEntity entity where entity.user.userId=:userId")})
@TableGenerator(name="user_authentication_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="user_authentication_id_seq", initialValue=2)
public class UserAuthenticationEntity {
    @Id
    @Column(name="user_authentication_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="user_authentication_id_generator")
    private Long userAuthenticationId;
    @Column(name="authentication_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Basic
    private UserAuthenticationType authenticationType = UserAuthenticationType.LOCAL;
    @Column(name="authentication_key")
    @Basic
    private String authenticationKey;
    @Column(name="create_time", nullable=false)
    @Basic
    private long createTime;
    @Column(name="update_time", nullable=false)
    @Basic
    private long updateTime;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", referencedColumnName="user_id", nullable=false)
    private UserEntity user;

    public Long getUserAuthenticationId() {
        return this.userAuthenticationId;
    }

    public void setUserAuthenticationId(Long userAuthenticationId) {
        this.userAuthenticationId = userAuthenticationId;
    }

    public UserAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(UserAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationKey() {
        int firstCommaIndex;
        if (this.getAuthenticationType().equals((Object)UserAuthenticationType.LOCAL) && (firstCommaIndex = this.authenticationKey.indexOf(",")) != -1) {
            return this.authenticationKey.substring(0, firstCommaIndex);
        }
        return this.authenticationKey;
    }

    public String getFullAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public void updateAuthenticationKey(String newAuthenticationKey, int historyCount) {
        if (this.authenticationKey == null || this.authenticationKey.isEmpty()) {
            this.authenticationKey = newAuthenticationKey;
        } else {
            String[] keys = this.authenticationKey.split(",");
            List<String> keyList = new ArrayList<String>(Arrays.asList(keys));
            if (keyList.size() >= historyCount) {
                keyList = keyList.subList(0, historyCount - 1);
            }
            keyList.add(0, newAuthenticationKey);
            this.authenticationKey = String.join((CharSequence)",", keyList);
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    @PrePersist
    protected void onCreate() {
        long now;
        this.createTime = now = System.currentTimeMillis();
        this.updateTime = now;
    }

    @PreUpdate
    protected void onUpdate() {
        this.updateTime = System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAuthenticationEntity that = (UserAuthenticationEntity)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.userAuthenticationId, (Object)that.userAuthenticationId);
        equalsBuilder.append((Object)this.authenticationType, (Object)that.authenticationType);
        equalsBuilder.append((Object)this.authenticationKey, (Object)that.authenticationKey);
        equalsBuilder.append(this.createTime, that.createTime);
        equalsBuilder.append(this.updateTime, that.updateTime);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append((Object)this.userAuthenticationId);
        hashCodeBuilder.append((Object)this.authenticationType);
        hashCodeBuilder.append((Object)this.authenticationKey);
        hashCodeBuilder.append(this.createTime);
        hashCodeBuilder.append(this.updateTime);
        return hashCodeBuilder.toHashCode();
    }
}

