/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.UpgradeGroupEntity;
import id.onyx.obdp.server.state.UpgradeState;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;

@Table(name="upgrade_item")
@Entity
@TableGenerator(name="upgrade_item_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="upgrade_item_id_seq", initialValue=0, allocationSize=1000)
@NamedQueries(value={@NamedQuery(name="UpgradeItemEntity.findAllStageIds", query="SELECT upgradeItem.stageId FROM UpgradeItemEntity upgradeItem")})
public class UpgradeItemEntity {
    @Id
    @Column(name="upgrade_item_id", nullable=false, insertable=true, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="upgrade_item_id_generator")
    private Long upgradeItemId;
    @Column(name="upgrade_group_id", nullable=false, insertable=false, updatable=false)
    private Long upgradeGroupId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="state", length=255, nullable=false)
    private UpgradeState state = UpgradeState.NONE;
    @Basic
    @Column(name="hosts")
    private String hosts = null;
    @Basic
    @Column(name="tasks", length=4096)
    private String tasks = null;
    @Basic
    @Column(name="item_text")
    private String itemText = null;
    @Basic
    @Column(name="stage_id", nullable=false)
    private Long stageId = 0L;
    @ManyToOne
    @JoinColumn(name="upgrade_group_id", referencedColumnName="upgrade_group_id", nullable=false)
    private UpgradeGroupEntity upgradeGroupEntity;

    public Long getId() {
        return this.upgradeItemId;
    }

    public void setId(Long id) {
        this.upgradeItemId = id;
    }

    public UpgradeState getState() {
        return this.state;
    }

    public void setState(UpgradeState state) {
        this.state = state;
    }

    public String getTasks() {
        return this.tasks;
    }

    public void setTasks(String json) {
        this.tasks = json;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String json) {
        this.hosts = json;
    }

    public String getText() {
        return this.itemText;
    }

    public void setText(String text) {
        this.itemText = text;
    }

    public UpgradeGroupEntity getGroupEntity() {
        return this.upgradeGroupEntity;
    }

    public void setGroupEntity(UpgradeGroupEntity entity) {
        this.upgradeGroupEntity = entity;
    }

    public Long getStageId() {
        return this.stageId;
    }

    public void setStageId(Long id) {
        this.stageId = id;
    }
}

