/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;

@Entity
@Table(name="upgrade_history", uniqueConstraints={@UniqueConstraint(columnNames={"upgrade_id", "component_name", "service_name"})})
@TableGenerator(name="upgrade_history_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="upgrade_history_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="UpgradeHistoryEntity.findAll", query="SELECT upgradeHistory FROM UpgradeHistoryEntity upgradeHistory"), @NamedQuery(name="UpgradeHistoryEntity.findByUpgradeId", query="SELECT upgradeHistory FROM UpgradeHistoryEntity upgradeHistory WHERE upgradeHistory.upgradeId = :upgradeId")})
public class UpgradeHistoryEntity {
    @Id
    @Column(name="id", nullable=false, insertable=true, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="upgrade_history_id_generator")
    private Long id;
    @Column(name="upgrade_id", nullable=false, insertable=false, updatable=false)
    private Long upgradeId;
    @JoinColumn(name="upgrade_id", nullable=false, insertable=false, updatable=false)
    private UpgradeEntity upgrade;
    @Column(name="service_name", nullable=false, insertable=true, updatable=true)
    private String serviceName;
    @Column(name="component_name", nullable=false, insertable=true, updatable=true)
    private String componentName;
    @ManyToOne
    @JoinColumn(name="from_repo_version_id", unique=false, nullable=false, insertable=true, updatable=true)
    private RepositoryVersionEntity fromRepositoryVersion = null;
    @ManyToOne
    @JoinColumn(name="target_repo_version_id", unique=false, nullable=false, insertable=true, updatable=true)
    private RepositoryVersionEntity targetRepositoryVersion = null;

    public Long getId() {
        return this.id;
    }

    public Long getUpgradeId() {
        return this.upgradeId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public RepositoryVersionEntity getFromReposistoryVersion() {
        return this.fromRepositoryVersion;
    }

    public void setFromRepositoryVersion(RepositoryVersionEntity repositoryVersionEntity) {
        this.fromRepositoryVersion = repositoryVersionEntity;
    }

    public RepositoryVersionEntity getTargetRepositoryVersion() {
        return this.targetRepositoryVersion;
    }

    public String getTargetVersion() {
        return this.targetRepositoryVersion.getVersion();
    }

    public void setTargetRepositoryVersion(RepositoryVersionEntity repositoryVersionEntity) {
        this.targetRepositoryVersion = repositoryVersionEntity;
    }

    public void setUpgrade(UpgradeEntity upgrade) {
        this.upgrade = upgrade;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeHistoryEntity that = (UpgradeHistoryEntity)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.upgradeId, (Object)that.upgradeId).append((Object)this.serviceName, (Object)that.serviceName).append((Object)this.componentName, (Object)that.componentName).isEquals();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.upgradeId, this.serviceName, this.componentName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("upgradeId", (Object)this.upgradeId).add("serviceName", (Object)this.serviceName).add("componentName", (Object)this.componentName).add("from", (Object)this.fromRepositoryVersion).add("to", (Object)this.targetRepositoryVersion).toString();
    }
}

