/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.UpgradeItemEntity;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.List;

@Table(name="upgrade_group")
@Entity
@TableGenerator(name="upgrade_group_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="upgrade_group_id_seq", initialValue=0, allocationSize=200)
public class UpgradeGroupEntity {
    @Id
    @Column(name="upgrade_group_id", nullable=false, insertable=true, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="upgrade_group_id_generator")
    private Long upgradeGroupId;
    @Column(name="upgrade_id", nullable=false, insertable=false, updatable=false)
    private Long upgradeId;
    @Basic
    @Column(name="group_name", length=255, nullable=false)
    private String groupName;
    @Basic
    @Column(name="group_title", length=1024, nullable=false)
    private String groupTitle;
    @ManyToOne
    @JoinColumn(name="upgrade_id", referencedColumnName="upgrade_id", nullable=false)
    private UpgradeEntity upgradeEntity;
    @OneToMany(mappedBy="upgradeGroupEntity", cascade={CascadeType.ALL})
    private List<UpgradeItemEntity> upgradeItems;

    public Long getId() {
        return this.upgradeGroupId;
    }

    public void setId(Long id) {
        this.upgradeGroupId = id;
    }

    public String getName() {
        return this.groupName;
    }

    public void setName(String name) {
        this.groupName = name;
    }

    public String getTitle() {
        return this.groupTitle;
    }

    public void setTitle(String title) {
        this.groupTitle = title;
    }

    public UpgradeEntity getUpgradeEntity() {
        return this.upgradeEntity;
    }

    public void setUpgradeEntity(UpgradeEntity entity) {
        this.upgradeEntity = entity;
    }

    public List<UpgradeItemEntity> getItems() {
        return this.upgradeItems;
    }

    public void setItems(List<UpgradeItemEntity> items) {
        for (UpgradeItemEntity item : items) {
            item.setGroupEntity(this);
        }
        this.upgradeItems = items;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("UpgradeGroupEntity{");
        buffer.append("upgradeGroupId=").append(this.upgradeGroupId);
        buffer.append(", upgradeId=").append(this.upgradeId);
        buffer.append(", groupName=").append(this.groupName);
        buffer.append(", groupTitle=").append(this.groupTitle);
        buffer.append("}");
        return buffer.toString();
    }
}

