/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.orm.entities;

import com.google.common.base.Objects;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.UpgradeGroupEntity;
import id.onyx.obdp.server.orm.entities.UpgradeHistoryEntity;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.spi.RepositoryType;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

@Entity
@Table(name="upgrade")
@TableGenerator(name="upgrade_id_generator", table="ambari_sequences", pkColumnName="sequence_name", valueColumnName="sequence_value", pkColumnValue="upgrade_id_seq", initialValue=0)
@NamedQueries(value={@NamedQuery(name="UpgradeEntity.findAll", query="SELECT u FROM UpgradeEntity u"), @NamedQuery(name="UpgradeEntity.findAllForCluster", query="SELECT u FROM UpgradeEntity u WHERE u.clusterId = :clusterId"), @NamedQuery(name="UpgradeEntity.findUpgrade", query="SELECT u FROM UpgradeEntity u WHERE u.upgradeId = :upgradeId"), @NamedQuery(name="UpgradeEntity.findUpgradeByRequestId", query="SELECT u FROM UpgradeEntity u WHERE u.requestId = :requestId"), @NamedQuery(name="UpgradeEntity.findLatestForClusterInDirection", query="SELECT u FROM UpgradeEntity u JOIN RequestEntity r ON u.requestId = r.requestId WHERE u.clusterId = :clusterId AND u.direction = :direction ORDER BY r.startTime DESC, u.upgradeId DESC"), @NamedQuery(name="UpgradeEntity.findLatestForCluster", query="SELECT u FROM UpgradeEntity u JOIN RequestEntity r ON u.requestId = r.requestId WHERE u.clusterId = :clusterId ORDER BY r.startTime DESC"), @NamedQuery(name="UpgradeEntity.findAllRequestIds", query="SELECT upgrade.requestId FROM UpgradeEntity upgrade"), @NamedQuery(name="UpgradeEntity.findRevertable", query="SELECT upgrade FROM UpgradeEntity upgrade WHERE upgrade.revertAllowed = 1 AND upgrade.clusterId = :clusterId ORDER BY upgrade.upgradeId DESC", hints={@QueryHint(name="eclipselink.query-results-cache", value="true"), @QueryHint(name="eclipselink.query-results-cache.ignore-null", value="false"), @QueryHint(name="eclipselink.query-results-cache.size", value="1")}), @NamedQuery(name="UpgradeEntity.findRevertableUsingJPQL", query="SELECT upgrade FROM UpgradeEntity upgrade WHERE upgrade.repoVersionId IN (SELECT upgrade.repoVersionId FROM UpgradeEntity upgrade WHERE upgrade.clusterId = :clusterId AND upgrade.orchestration IN :revertableTypes GROUP BY upgrade.repoVersionId HAVING MOD(COUNT(upgrade.repoVersionId), 2) != 0) ORDER BY upgrade.upgradeId DESC", hints={@QueryHint(name="eclipselink.query-results-cache", value="true"), @QueryHint(name="eclipselink.query-results-cache.ignore-null", value="false"), @QueryHint(name="eclipselink.query-results-cache.size", value="1")})})
public class UpgradeEntity {
    @Id
    @Column(name="upgrade_id", nullable=false, insertable=true, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="upgrade_id_generator")
    private Long upgradeId;
    @Column(name="cluster_id", nullable=false, insertable=true, updatable=false)
    private Long clusterId;
    @Column(name="request_id", nullable=false, insertable=false, updatable=false)
    private Long requestId;
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="request_id", nullable=false, insertable=true, updatable=false)
    private RequestEntity requestEntity = null;
    @Column(name="direction", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private Direction direction = Direction.UPGRADE;
    @Column(name="upgrade_package", nullable=false)
    private String upgradePackage;
    @Column(name="upgrade_package_stack", nullable=false)
    private String upgradePackStack;
    @Column(name="upgrade_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private UpgradeType upgradeType;
    @Column(name="repo_version_id", insertable=false, updatable=false)
    private Long repoVersionId;
    @JoinColumn(name="repo_version_id", referencedColumnName="repo_version_id", nullable=false)
    private RepositoryVersionEntity repositoryVersion;
    @Column(name="skip_failures", nullable=false)
    private Integer skipFailures = 0;
    @Column(name="skip_sc_failures", nullable=false)
    private Integer skipServiceCheckFailures = 0;
    @Column(name="downgrade_allowed", nullable=false)
    private Short downgradeAllowed = 1;
    @Column(name="revert_allowed", nullable=false)
    private Short revertAllowed = 0;
    @Column(name="orchestration", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private RepositoryType orchestration = RepositoryType.STANDARD;
    @Column(name="suspended", nullable=false, length=1)
    private Short suspended = 0;
    @OneToMany(mappedBy="upgradeEntity", cascade={CascadeType.ALL})
    private List<UpgradeGroupEntity> upgradeGroupEntities;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="upgrade_id")
    private List<UpgradeHistoryEntity> upgradeHistory;

    public Long getId() {
        return this.upgradeId;
    }

    public void setId(Long id) {
        this.upgradeId = id;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long id) {
        this.clusterId = id;
    }

    public List<UpgradeGroupEntity> getUpgradeGroups() {
        return this.upgradeGroupEntities;
    }

    public void setUpgradeGroups(List<UpgradeGroupEntity> items) {
        for (UpgradeGroupEntity entity : items) {
            entity.setUpgradeEntity(this);
        }
        this.upgradeGroupEntities = items;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestEntity(RequestEntity requestEntity) {
        this.requestEntity = requestEntity;
        this.requestId = requestEntity.getRequestId();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public Boolean isDowngradeAllowed() {
        return this.downgradeAllowed != null ? Boolean.valueOf(this.downgradeAllowed != 0) : null;
    }

    public void setDowngradeAllowed(boolean canDowngrade) {
        this.downgradeAllowed = !canDowngrade ? (short)0 : 1;
    }

    public Boolean isRevertAllowed() {
        return this.revertAllowed != null ? Boolean.valueOf(this.revertAllowed != 0) : null;
    }

    public void setRevertAllowed(boolean revertable) {
        this.revertAllowed = !revertable ? (short)0 : 1;
    }

    public void setUpgradeType(UpgradeType upgradeType) {
        this.upgradeType = upgradeType;
    }

    public String getUpgradePackage() {
        return this.upgradePackage;
    }

    public void setUpgradePackage(String upgradePackage) {
        this.upgradePackage = upgradePackage;
    }

    public StackId getUpgradePackStackId() {
        return null == this.upgradePackStack ? null : new StackId(this.upgradePackStack);
    }

    public void setUpgradePackStackId(StackId stackId) {
        this.upgradePackStack = stackId.toString();
    }

    public boolean isComponentFailureAutoSkipped() {
        return this.skipFailures != 0;
    }

    public void setAutoSkipComponentFailures(boolean autoSkipComponentFailures) {
        this.skipFailures = autoSkipComponentFailures ? 1 : 0;
    }

    public boolean isServiceCheckFailureAutoSkipped() {
        return this.skipServiceCheckFailures != 0;
    }

    public void setAutoSkipServiceCheckFailures(boolean autoSkipServiceCheckFailures) {
        this.skipServiceCheckFailures = autoSkipServiceCheckFailures ? 1 : 0;
    }

    public boolean isSuspended() {
        return this.suspended != 0;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended ? (short)1 : 0;
    }

    public void addHistory(UpgradeHistoryEntity historicalEntry) {
        if (null == this.upgradeHistory) {
            this.upgradeHistory = new ArrayList<UpgradeHistoryEntity>();
        }
        this.upgradeHistory.add(historicalEntry);
    }

    public List<UpgradeHistoryEntity> getHistory() {
        return this.upgradeHistory;
    }

    public RepositoryVersionEntity getRepositoryVersion() {
        return this.repositoryVersion;
    }

    public void setRepositoryVersion(RepositoryVersionEntity repositoryVersion) {
        this.repositoryVersion = repositoryVersion;
    }

    public void setOrchestration(RepositoryType type) {
        this.orchestration = type;
    }

    public RepositoryType getOrchestration() {
        return this.orchestration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeEntity that = (UpgradeEntity)o;
        return new EqualsBuilder().append((Object)this.upgradeId, (Object)that.upgradeId).append((Object)this.clusterId, (Object)that.clusterId).append((Object)this.requestId, (Object)that.requestId).append((Object)this.direction, (Object)that.direction).append((Object)this.suspended, (Object)that.suspended).append((Object)this.upgradeType, (Object)that.upgradeType).append((Object)this.upgradePackage, (Object)that.upgradePackage).isEquals();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.upgradeId, this.clusterId, this.requestId, this.direction, this.suspended, this.upgradeType, this.upgradePackage});
    }

    public void removeHistories(Collection<UpgradeHistoryEntity> upgradeHistoryEntity) {
        if (this.upgradeHistory != null) {
            this.upgradeHistory.removeAll(upgradeHistoryEntity);
        }
    }
}

